/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import android.text.TextUtils;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.ResponseXmlS3BodySerializer;
import com.tencent.cos.xml.model.object.ListPartsResult;
import com.tencent.qcloud.core.network.QCloudRequestPriority;
import java.util.Iterator;
import java.util.Map;

public final class ListPartsRequest
extends CosXmlRequest {
    private String uploadId;
    private String maxParts;
    private String partNumberMarker;
    private String encodingType;
    private String cosPath;

    public ListPartsRequest(String bucket, String cosPath, String uploadId) {
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.uploadId = uploadId;
        this.contentType = "application/x-www-form-urlencoded";
        this.requestHeaders.put("Content-Type", this.contentType);
    }

    @Override
    protected void build() throws CosXmlClientException {
        Map.Entry entry;
        Map.Entry object;
        Iterator iterator;
        super.build();
        this.priority = QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_NORMAL;
        this.setRequestMethod();
        this.requestOriginBuilder.method(this.requestMethod);
        this.setRequestPath();
        this.requestOriginBuilder.pathAddRear(this.requestPath);
        this.requestOriginBuilder.hostAddFront(this.bucket);
        this.setRequestQueryParams();
        if (this.requestQueryParams.size() > 0) {
            iterator = this.requestQueryParams.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = object = iterator.next();
                this.requestOriginBuilder.query((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.requestHeaders.size() > 0) {
            iterator = this.requestHeaders.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = object = iterator.next();
                this.requestOriginBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.responseBodySerializer = new ResponseXmlS3BodySerializer(ListPartsResult.class);
    }

    @Override
    protected void setRequestQueryParams() {
        if (!TextUtils.isEmpty((CharSequence)this.uploadId)) {
            this.requestQueryParams.put("uploadID", this.uploadId);
        }
        if (!TextUtils.isEmpty((CharSequence)this.maxParts)) {
            this.requestQueryParams.put("max-parts", this.maxParts);
        }
        if (!TextUtils.isEmpty((CharSequence)this.partNumberMarker)) {
            this.requestQueryParams.put("part-number-marker", this.partNumberMarker);
        }
        if (!TextUtils.isEmpty((CharSequence)this.encodingType)) {
            this.requestQueryParams.put("Encoding-type", this.encodingType);
        }
    }

    @Override
    protected void checkParameters() throws CosXmlClientException {
        if (this.bucket == null) {
            throw new CosXmlClientException("bucket must not be null");
        }
        if (this.cosPath == null) {
            throw new CosXmlClientException("cosPath must not be null");
        }
        if (this.uploadId == null) {
            throw new CosXmlClientException("uploadID must not be null");
        }
    }

    @Override
    protected void setRequestMethod() {
        this.requestMethod = "GET";
    }

    @Override
    protected void setRequestPath() {
        if (this.cosPath != null) {
            this.requestPath = !this.cosPath.startsWith("/") ? "/" + this.cosPath : this.cosPath;
        }
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setMaxParts(int maxParts) {
        maxParts = maxParts <= 0 ? 1 : maxParts;
        this.maxParts = String.valueOf(maxParts);
    }

    public int getMaxParts() {
        return Integer.parseInt(this.maxParts);
    }

    public void setPartNumberMarker(int partNumberMarker) {
        this.partNumberMarker = String.valueOf(partNumberMarker);
    }

    public int getPartNumberMarker() {
        return Integer.parseInt(this.partNumberMarker);
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public void setCosPath(String cosPath) {
        this.cosPath = cosPath;
    }

    public String getCosPath() {
        return this.cosPath;
    }
}

