/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.ResponseXmlS3BodySerializer;
import com.tencent.cos.xml.model.object.DeleteMultiObjectResult;
import com.tencent.cos.xml.model.tag.Delete;
import com.tencent.cos.xml.model.tag.DeleteObject;
import com.tencent.qcloud.core.network.QCloudRequestPriority;
import com.tencent.qcloud.core.network.action.QCloudBodyMd5Action;
import com.tencent.qcloud.core.network.request.serializer.RequestBodySerializer;
import com.tencent.qcloud.core.network.request.serializer.RequestXmlBodySerializer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class DeleteMultiObjectRequest
extends CosXmlRequest {
    private Delete delete;

    public DeleteMultiObjectRequest(String bucket, List<String> deleteObjectList) {
        this.bucket = bucket;
        this.delete = new Delete();
        this.contentType = "application/xml";
        this.requestHeaders.put("Content-Type", this.contentType);
        this.delete.deleteObjectList = new ArrayList<DeleteObject>();
        this.setObjectList(deleteObjectList);
    }

    @Override
    protected void build() throws CosXmlClientException {
        Map.Entry entry;
        Map.Entry object;
        Iterator iterator;
        super.build();
        this.priority = QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_NORMAL;
        this.setRequestMethod();
        this.requestOriginBuilder.method(this.requestMethod);
        this.setRequestPath();
        this.requestOriginBuilder.pathAddRear(this.requestPath);
        this.requestOriginBuilder.hostAddFront(this.bucket);
        this.setRequestQueryParams();
        if (this.requestQueryParams.size() > 0) {
            iterator = this.requestQueryParams.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = object = iterator.next();
                this.requestOriginBuilder.query((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.requestHeaders.size() > 0) {
            iterator = this.requestHeaders.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = object = iterator.next();
                this.requestOriginBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.requestOriginBuilder.body((RequestBodySerializer)new RequestXmlBodySerializer((Object)this.delete));
        this.requestActions.add(new QCloudBodyMd5Action());
        this.responseBodySerializer = new ResponseXmlS3BodySerializer(DeleteMultiObjectResult.class);
    }

    @Override
    protected void setRequestQueryParams() {
        this.requestQueryParams.put("delete", null);
    }

    @Override
    protected void checkParameters() throws CosXmlClientException {
        if (this.bucket == null) {
            throw new CosXmlClientException("bucket must not be null");
        }
    }

    @Override
    protected void setRequestMethod() {
        this.requestMethod = "POST";
    }

    @Override
    protected void setRequestPath() {
        this.requestPath = "/";
    }

    public void setQuiet(boolean quiet) {
        this.delete.quiet = quiet;
    }

    public void setObjectList(String object) {
        if (object != null) {
            if (object.startsWith("/")) {
                object = object.substring(1);
            }
            DeleteObject deleteObject = new DeleteObject();
            deleteObject.key = object;
            this.delete.deleteObjectList.add(deleteObject);
        }
    }

    public void setObjectList(List<String> objectList) {
        if (objectList != null) {
            int size = objectList.size();
            for (int i = 0; i < size; ++i) {
                DeleteObject deleteObject = new DeleteObject();
                String object = objectList.get(i);
                deleteObject.key = object.startsWith("/") ? object.substring(1) : object;
                this.delete.deleteObjectList.add(deleteObject);
            }
        }
    }

    public Delete getDelete() {
        return this.delete;
    }
}

