/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.common.COSACL;
import com.tencent.cos.xml.common.COSStorageClass;
import com.tencent.cos.xml.common.MetaDataDirective;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.ResponseXmlS3BodySerializer;
import com.tencent.cos.xml.model.object.CopyObjectResult;
import com.tencent.qcloud.core.network.QCloudRequestPriority;
import com.tencent.qcloud.core.network.request.serializer.RequestBodySerializer;
import com.tencent.qcloud.core.network.request.serializer.RequestByteArraySerializer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CopyObjectRequest
extends CosXmlRequest {
    private CopySourceStruct copySourceStruct;
    private String cosPath;

    public CopyObjectRequest(String bucket, String cosPath, CopySourceStruct copySourceStruct) {
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.copySourceStruct = copySourceStruct;
        this.contentType = "text/plain";
        this.requestHeaders.put("Content-Type", this.contentType);
        this.setCopySource(copySourceStruct);
    }

    @Override
    protected void setRequestMethod() {
        this.requestMethod = "PUT";
    }

    @Override
    protected void setRequestPath() {
        if (this.cosPath != null) {
            this.requestPath = !this.cosPath.startsWith("/") ? "/" + this.cosPath : this.cosPath;
        }
    }

    @Override
    protected void setRequestQueryParams() {
    }

    @Override
    public void checkParameters() throws CosXmlClientException {
        if (this.bucket == null) {
            throw new CosXmlClientException("bucket must not be null");
        }
        if (this.cosPath == null) {
            throw new CosXmlClientException("cosPath must not be null");
        }
        if (this.copySourceStruct == null) {
            throw new CosXmlClientException("copy source must not be null");
        }
        this.copySourceStruct.checkParameters();
    }

    @Override
    public void build() throws CosXmlClientException {
        Map.Entry entry;
        Map.Entry object;
        Iterator iterator;
        super.build();
        this.priority = QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_NORMAL;
        this.setRequestMethod();
        this.requestOriginBuilder.method(this.requestMethod);
        this.setRequestPath();
        this.requestOriginBuilder.pathAddRear(this.requestPath);
        this.requestOriginBuilder.hostAddFront(this.bucket);
        this.setRequestQueryParams();
        if (this.requestQueryParams.size() > 0) {
            iterator = this.requestQueryParams.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = object = iterator.next();
                this.requestOriginBuilder.query((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.requestHeaders.size() > 0) {
            iterator = this.requestHeaders.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = object = iterator.next();
                this.requestOriginBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.requestOriginBuilder.body((RequestBodySerializer)new RequestByteArraySerializer(new byte[0], "text/plain"));
        this.responseBodySerializer = new ResponseXmlS3BodySerializer(CopyObjectResult.class);
    }

    public void setCosPath(String cosPath) {
        this.cosPath = cosPath;
    }

    public String getCosPath() {
        return this.cosPath;
    }

    public void setCopySource(CopySourceStruct copySource) {
        this.copySourceStruct = copySource;
        if (this.copySourceStruct != null) {
            this.requestHeaders.put("x-cos-copy-source", this.copySourceStruct.toString());
        }
    }

    public String getCopySource() {
        return this.copySourceStruct.toString();
    }

    public void setCopyMetaDataDirective(MetaDataDirective metaDataDirective) {
        if (metaDataDirective != null) {
            this.requestHeaders.put("x-cos-metadata-directive", metaDataDirective.getMetaDirective());
        }
    }

    public void setCopyIfModifiedSince(String sourceIfModifiedSince) {
        if (sourceIfModifiedSince != null) {
            this.requestHeaders.put("x-cos-copy-source-If-Modified-Since", sourceIfModifiedSince);
        }
    }

    public void setCopyIfUnmodifiedSince(String sourceIfUnmodifiedSince) {
        if (sourceIfUnmodifiedSince != null) {
            this.requestHeaders.put("x-cos-copy-source-If-Unmodified-Since", sourceIfUnmodifiedSince);
        }
    }

    public void setCopyIfMatch(String eTag) {
        if (eTag != null) {
            this.requestHeaders.put("x-cos-copy-source-If-Match", eTag);
        }
    }

    public void setCopyIfNoneMatch(String eTag) {
        if (eTag != null) {
            this.requestHeaders.put("x-cos-copy-source-If-None-Match", eTag);
        }
    }

    public void setCosStorageClass(COSStorageClass cosStorageClass) {
        if (cosStorageClass != null) {
            this.requestHeaders.put("x-cos-storage-class", cosStorageClass.getStorageClass());
        }
    }

    public void setXCOSACL(COSACL cosacl) {
        if (cosacl != null) {
            this.requestHeaders.put("x-cos-acl", cosacl.getACL());
        }
    }

    public void setXCOSGrantRead(List<String> uinList) {
        this.setXCOSGrant(uinList, 0);
    }

    public void setXCOSGrantWrite(List<String> uinList) {
        this.setXCOSGrant(uinList, 1);
    }

    public void setXCOSReadWrite(List<String> uinList) {
        this.setXCOSGrant(uinList, 2);
    }

    private void setXCOSGrant(List<String> uinList, int grantType) {
        String result = this.generateXCOSGrant(uinList);
        if (result != null) {
            switch (grantType) {
                case 0: {
                    this.requestHeaders.put("x-cos-grant-read", result);
                    break;
                }
                case 1: {
                    this.requestHeaders.put("x-cos-grant-write", result);
                    break;
                }
                case 2: {
                    this.requestHeaders.put("x-cos-grant-full-control", result);
                }
            }
        }
    }

    private String generateXCOSGrant(List<String> uinList) {
        int size;
        String result = null;
        if (uinList != null && (size = uinList.size()) > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < size - 1; ++i) {
                stringBuilder.append("id=\"qcs::cam::").append(uinList.get(i)).append("\"").append(",");
            }
            stringBuilder.append("id=\"qcs::cam::").append(uinList.get(size - 1)).append("\"");
            result = stringBuilder.toString();
        }
        return result;
    }

    public void setXCOSMeta(String key, String value) {
        if (key != null && value != null) {
            this.requestHeaders.put(key, value);
        }
    }

    public static class CopySourceStruct {
        private String appid;
        private String bucket;
        private String region;
        private String cosPath;

        public CopySourceStruct(String appid, String bucket, String region, String cosPath) {
            this.appid = appid;
            this.bucket = bucket;
            this.region = region;
            this.cosPath = cosPath;
        }

        public void checkParameters() throws CosXmlClientException {
            if (this.bucket == null) {
                throw new CosXmlClientException("copy source bucket must not be null");
            }
            if (this.cosPath == null) {
                throw new CosXmlClientException("copy source cosPath must not be null");
            }
            if (this.appid == null) {
                throw new CosXmlClientException("copy source appid must not be null");
            }
            if (this.region == null) {
                throw new CosXmlClientException("copy source region must not be null");
            }
        }

        public String toString() {
            if (this.cosPath != null && !this.cosPath.startsWith("/")) {
                this.cosPath = "/" + this.cosPath;
            }
            StringBuilder copySource = new StringBuilder();
            copySource.append(this.bucket).append("-").append(this.appid).append(".").append("cos").append(".").append(this.region).append(".").append("myqcloud.com").append(this.cosPath);
            return copySource.toString();
        }
    }
}

