/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model;

import com.tencent.cos.xml.CosXmlServiceConfig;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.qcloud.core.network.QCloudHttpRequest;
import com.tencent.qcloud.core.network.QCloudResult;
import com.tencent.qcloud.core.network.auth.COSXmlSignSourceProvider;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class CosXmlRequest<T extends QCloudResult>
extends QCloudHttpRequest<T> {
    protected String requestMethod = "GET";
    protected String requestPath;
    protected Map<String, String> requestQueryParams = new LinkedHashMap<String, String>();
    protected Map<String, String> requestHeaders = new LinkedHashMap<String, String>();
    protected Map<String, String> requestBodyParams = new LinkedHashMap<String, String>();
    protected String contentType = "application/xml";
    protected String expect;
    protected String contentMd5;
    protected String bucket;

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setSign(long signDuration, Set<String> checkHeaderListForSign, Set<String> checkParameterListForSign) {
        if (signDuration < 0L) {
            signDuration = 600L;
        }
        COSXmlSignSourceProvider cosSignSourceProvider = new COSXmlSignSourceProvider(signDuration);
        if (checkHeaderListForSign != null) {
            cosSignSourceProvider.headers(checkHeaderListForSign);
        }
        if (checkParameterListForSign != null) {
            cosSignSourceProvider.parameters(checkParameterListForSign);
        }
        this.signSourceProvider = cosSignSourceProvider;
        this.setSignerType("CosXmlSigner");
    }

    public void setSign(long signDuration) {
        if (signDuration < 0L) {
            signDuration = 600L;
        }
        COSXmlSignSourceProvider cosSignSourceProvider = new COSXmlSignSourceProvider(signDuration);
        this.signSourceProvider = cosSignSourceProvider;
        this.setSignerType("CosXmlSigner");
    }

    public void setExpect(String expect) {
        if (expect == null) {
            return;
        }
        this.expect = expect;
        this.requestHeaders.put("Expect", expect);
    }

    public void setContentMd5(String contentMd5) {
        if (contentMd5 == null) {
            return;
        }
        this.contentMd5 = contentMd5;
        this.requestHeaders.put("Content-MD5", contentMd5);
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public Map<String, String> getRequestQueryParams() {
        return this.requestQueryParams;
    }

    public Map<String, String> getRequestBodyParams() {
        return this.requestBodyParams;
    }

    public String getExpect() {
        return this.expect;
    }

    public String getContentMd5() {
        return this.contentMd5;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    protected abstract void setRequestMethod();

    protected abstract void setRequestPath();

    protected abstract void setRequestQueryParams();

    protected void build() throws CosXmlClientException {
        this.checkParameters();
        this.requestOriginBuilder.scheme(CosXmlServiceConfig.getInstance().getScheme());
        this.requestOriginBuilder.hostAddFront(CosXmlServiceConfig.getInstance().getHttpHost());
    }

    protected abstract void checkParameters() throws CosXmlClientException;
}

