/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import android.support.annotation.NonNull;
import com.tencent.cos.xml.common.COSACL;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.ResponseXmlS3BodySerializer;
import com.tencent.cos.xml.model.object.PutObjectResult;
import com.tencent.cos.xml.model.tag.ACLAccounts;
import com.tencent.qcloud.core.network.QCloudProgressListener;
import com.tencent.qcloud.core.network.QCloudRequestPriority;
import com.tencent.qcloud.core.network.request.serializer.RequestBodySerializer;
import com.tencent.qcloud.core.network.request.serializer.RequestByteArraySerializer;
import com.tencent.qcloud.core.network.request.serializer.RequestFileBodySerializer;
import com.tencent.qcloud.core.network.request.serializer.RequestStreamBodySerializer;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;

public final class PutObjectRequest
extends CosXmlRequest {
    private String cosPath;
    private String srcPath;
    private byte[] data;
    private InputStream inputStream;
    private long fileLength;
    private QCloudProgressListener progressListener;

    public PutObjectRequest(String bucket, String cosPath, String srcPath) {
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.srcPath = srcPath;
        this.contentType = "text/plain";
        this.requestHeaders.put("Content-Type", this.contentType);
    }

    public PutObjectRequest(String bucket, String cosPath, byte[] data) {
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.data = data;
        this.contentType = "text/plain";
        this.requestHeaders.put("Content-Type", this.contentType);
    }

    public PutObjectRequest(String bucket, String cosPath, InputStream inputStream, long sendLength) {
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.inputStream = inputStream;
        this.fileLength = sendLength;
        this.contentType = "text/plain";
        this.requestHeaders.put("Content-Type", this.contentType);
    }

    @Override
    protected void build() throws CosXmlClientException {
        Map.Entry entry;
        Map.Entry object;
        Iterator iterator;
        super.build();
        this.priority = QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_LOW;
        this.setRequestMethod();
        this.requestOriginBuilder.method(this.requestMethod);
        this.setRequestPath();
        this.requestOriginBuilder.pathAddRear(this.requestPath);
        this.requestOriginBuilder.hostAddFront(this.bucket);
        this.setRequestQueryParams();
        if (this.requestQueryParams.size() > 0) {
            iterator = this.requestQueryParams.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = object = iterator.next();
                this.requestOriginBuilder.query((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.requestHeaders.size() > 0) {
            iterator = this.requestHeaders.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = object = iterator.next();
                this.requestOriginBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.srcPath != null) {
            RequestFileBodySerializer requestFileBodySerializer = new RequestFileBodySerializer(this.srcPath, "text/plain");
            requestFileBodySerializer.setProgressListener(this.progressListener);
            this.requestOriginBuilder.body((RequestBodySerializer)requestFileBodySerializer);
        } else if (this.data != null) {
            RequestByteArraySerializer requestByteArraySerializer = new RequestByteArraySerializer(this.data, "text/plain");
            requestByteArraySerializer.setProgressListener(this.progressListener);
            this.requestOriginBuilder.body((RequestBodySerializer)requestByteArraySerializer);
        } else if (this.inputStream != null) {
            RequestStreamBodySerializer requestStreamBodySerializer = new RequestStreamBodySerializer(this.inputStream, this.fileLength, "text/plain");
            requestStreamBodySerializer.setProgressListener(this.progressListener);
            this.requestOriginBuilder.body((RequestBodySerializer)requestStreamBodySerializer);
        }
        this.responseBodySerializer = new ResponseXmlS3BodySerializer(PutObjectResult.class);
    }

    @Override
    protected void setRequestQueryParams() {
    }

    @Override
    protected void checkParameters() throws CosXmlClientException {
        File file;
        if (this.bucket == null) {
            throw new CosXmlClientException("bucket must not be null");
        }
        if (this.cosPath == null) {
            throw new CosXmlClientException("cosPath must not be null");
        }
        if (this.srcPath == null && this.data == null && this.inputStream == null) {
            throw new CosXmlClientException("Data Source must not be null");
        }
        if (this.srcPath != null && !(file = new File(this.srcPath)).exists()) {
            throw new CosXmlClientException("upload file does not exist");
        }
    }

    @Override
    protected void setRequestMethod() {
        this.requestMethod = "PUT";
    }

    @Override
    protected void setRequestPath() {
        if (this.cosPath != null) {
            this.requestPath = !this.cosPath.startsWith("/") ? "/" + this.cosPath : this.cosPath;
        }
    }

    public void setProgressListener(QCloudProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public QCloudProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setCosPath(String cosPath) {
        this.cosPath = cosPath;
    }

    public String getCosPath() {
        return this.cosPath;
    }

    public void setSrcPath(@NonNull String srcPath) {
        this.srcPath = srcPath;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setInputStream(InputStream inputStream, long fileLength) {
        this.inputStream = inputStream;
        this.fileLength = fileLength;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public long getFileLength() {
        if (this.inputStream != null) {
            return this.fileLength;
        }
        if (this.srcPath != null) {
            return new File(this.srcPath).length();
        }
        if (this.data != null) {
            return this.data.length;
        }
        return -1L;
    }

    public void setCacheControl(String cacheControl) {
        if (cacheControl == null) {
            return;
        }
        this.requestHeaders.put("Cache-Control", cacheControl);
    }

    public void setContentDisposition(String contentDisposition) {
        if (contentDisposition == null) {
            return;
        }
        this.requestHeaders.put("Content-Disposition", contentDisposition);
    }

    public void setContentEncodeing(String contentEncodeing) {
        if (contentEncodeing == null) {
            return;
        }
        this.requestHeaders.put("Content-Encoding", contentEncodeing);
    }

    public void setExpires(String expires) {
        if (expires == null) {
            return;
        }
        this.requestHeaders.put("Expires", expires);
    }

    public void setXCOSMeta(String key, String value) {
        if (key != null && value != null) {
            this.requestHeaders.put(key, value);
        }
    }

    public void setXCOSACL(COSACL xCOSACL) {
        if (xCOSACL != null) {
            this.requestHeaders.put("x-cos-acl", xCOSACL.getACL());
        }
    }

    public void setXCOSACL(String xCOSACL) {
        if (xCOSACL != null) {
            this.requestHeaders.put("x-cos-acl", xCOSACL);
        }
    }

    public void setXCOSGrantRead(ACLAccounts aclAccounts) {
        if (aclAccounts != null) {
            this.requestHeaders.put("x-cos-grant-read", aclAccounts.aclDesc());
        }
    }

    public void setXCOSGrantWrite(ACLAccounts aclAccounts) {
        if (aclAccounts != null) {
            this.requestHeaders.put("x-cos-grant-write", aclAccounts.aclDesc());
        }
    }

    public void setXCOSReadWrite(ACLAccounts aclAccounts) {
        if (aclAccounts != null) {
            this.requestHeaders.put("x-cos-grant-full-control", aclAccounts.aclDesc());
        }
    }
}

