/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.object.UploadPartResult;
import com.tencent.qcloud.network.QCloudProgressListener;
import com.tencent.qcloud.network.QCloudRequest;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.exception.QCloudExceptionType;
import com.tencent.qcloud.network.request.serializer.body.RequestByteArraySerializer;
import com.tencent.qcloud.network.request.serializer.body.RequestFileBodySerializer;
import com.tencent.qcloud.network.request.serializer.body.RequestStreamBodySerializer;
import com.tencent.qcloud.network.response.serializer.body.ResponseXmlS3BodySerializer;
import com.tencent.qcloud.network.response.serializer.http.HttpPassAllSerializer;
import java.io.File;
import java.io.InputStream;
import java.util.Map;

public class UploadPartRequest
extends CosXmlRequest {
    private int partNumber;
    private String uploadId;
    private String cosPath;
    private String srcPath;
    private byte[] data;
    private InputStream inputStream;
    private long fileLength;
    private long fileOffset;
    private long fileContentLength;
    private QCloudProgressListener progressListener;

    public UploadPartRequest() {
        this.contentType = "text/plain";
        this.requestHeaders.put("Content-Type", this.contentType);
        this.fileOffset = -1L;
        this.fileContentLength = -1L;
    }

    public void build() {
        this.priority = QCloudRequest.QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_LOW;
        this.setRequestMethod();
        this.requestOriginBuilder.method(this.requestMethod);
        this.setRequestPath();
        this.requestOriginBuilder.pathAddRear(this.requestPath);
        this.requestOriginBuilder.hostAddFront(this.bucket);
        this.setRequestQueryParams();
        if (this.requestQueryParams.size() > 0) {
            for (Map.Entry entry : this.requestQueryParams.entrySet()) {
                this.requestOriginBuilder.query((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.requestHeaders.size() > 0) {
            for (Map.Entry entry : this.requestHeaders.entrySet()) {
                this.requestOriginBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.srcPath != null) {
            RequestFileBodySerializer requestFileBodySerializer = new RequestFileBodySerializer(this.srcPath, "text/plain", this.fileOffset, this.fileContentLength);
            requestFileBodySerializer.setProgressListener(this.progressListener);
            this.requestBodySerializer = requestFileBodySerializer;
        } else if (this.data != null) {
            RequestByteArraySerializer requestByteArraySerializer = new RequestByteArraySerializer(this.data, "text/plain");
            requestByteArraySerializer.setProgressListener(this.progressListener);
            this.requestBodySerializer = requestByteArraySerializer;
        } else if (this.inputStream != null) {
            RequestStreamBodySerializer requestStreamBodySerializer = new RequestStreamBodySerializer(this.inputStream, this.fileLength, "text/plain");
            requestStreamBodySerializer.setProgressListener(this.progressListener);
            this.requestBodySerializer = requestStreamBodySerializer;
        }
        this.responseSerializer = new HttpPassAllSerializer();
        this.responseBodySerializer = new ResponseXmlS3BodySerializer(UploadPartResult.class);
    }

    public void setPartNumber(int partNumber) {
        this.partNumber = partNumber;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    @Override
    protected void setRequestQueryParams() {
        this.requestQueryParams.put("partNumber", String.valueOf(this.partNumber));
        this.requestQueryParams.put("uploadID", this.uploadId);
    }

    @Override
    public void checkParameters() throws QCloudException {
        File file;
        if (this.bucket == null) {
            throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "bucket must not be null");
        }
        if (this.partNumber <= 0) {
            throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "partNumber must be >= 1");
        }
        if (this.uploadId == null) {
            throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "uploadID must not be null");
        }
        if (this.cosPath == null) {
            throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "cosPath must not be null");
        }
        if (this.srcPath == null && this.data == null && this.inputStream == null) {
            throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "Data Source must not be null");
        }
        if (this.srcPath != null && !(file = new File(this.srcPath)).exists()) {
            throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "upload file does not exist");
        }
    }

    @Override
    protected void setRequestMethod() {
        this.requestMethod = "PUT";
    }

    @Override
    protected void setRequestPath() {
        if (this.cosPath != null) {
            this.requestPath = !this.cosPath.startsWith("/") ? "/" + this.cosPath : this.cosPath;
        }
    }

    public void setCosPath(String cosPath) {
        this.cosPath = cosPath;
    }

    public String getCosPath() {
        return this.cosPath;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    public void setSrcPath(String srcPath, long fileOffset, long contentLength) {
        this.srcPath = srcPath;
        this.fileOffset = fileOffset;
        this.fileContentLength = contentLength;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setInputStream(InputStream inputStream, long fileLength) {
        this.inputStream = inputStream;
        this.fileLength = fileLength;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public void setProgressListener(QCloudProgressListener progressListener) {
        this.progressListener = progressListener;
    }
}

