/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.bucket;

import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.bucket.PutBucketTaggingResult;
import com.tencent.cos.xml.model.tag.Tag;
import com.tencent.cos.xml.model.tag.TagSet;
import com.tencent.cos.xml.model.tag.Tagging;
import com.tencent.qcloud.network.QCloudHttpRequest;
import com.tencent.qcloud.network.QCloudRequest;
import com.tencent.qcloud.network.action.QCloudBodyMd5Action;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.exception.QCloudExceptionType;
import com.tencent.qcloud.network.request.serializer.body.RequestXmlBodySerializer;
import com.tencent.qcloud.network.response.serializer.body.ResponseXmlS3BodySerializer;
import com.tencent.qcloud.network.response.serializer.http.HttpPassAllSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PutBucketTaggingRequest
extends CosXmlRequest {
    private Tagging tagging;

    public PutBucketTaggingRequest() {
        this.contentType = "application/xml";
        this.requestHeaders.put("Content-Type", this.contentType);
        this.tagging = new Tagging();
        this.tagging.tagSet = new TagSet();
        this.tagging.tagSet.tagList = new ArrayList<Tag>();
    }

    public void build() {
        this.priority = QCloudRequest.QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_NORMAL;
        this.setRequestMethod();
        this.requestOriginBuilder.method(this.requestMethod);
        this.setRequestPath();
        this.requestOriginBuilder.pathAddRear(this.requestPath);
        this.requestOriginBuilder.hostAddFront(this.bucket);
        this.setRequestQueryParams();
        if (this.requestQueryParams.size() > 0) {
            for (Map.Entry entry : this.requestQueryParams.entrySet()) {
                this.requestOriginBuilder.query((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.requestHeaders.size() > 0) {
            for (Map.Entry entry : this.requestHeaders.entrySet()) {
                this.requestOriginBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.requestActions.add(new QCloudBodyMd5Action((QCloudHttpRequest)this));
        this.requestBodySerializer = new RequestXmlBodySerializer((Object)this.tagging);
        this.responseSerializer = new HttpPassAllSerializer();
        this.responseBodySerializer = new ResponseXmlS3BodySerializer(PutBucketTaggingResult.class);
    }

    @Override
    protected void setRequestQueryParams() {
        this.requestQueryParams.put("tagging", null);
    }

    @Override
    public void checkParameters() throws QCloudException {
        if (this.bucket == null) {
            throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "bucket must not be null");
        }
    }

    @Override
    protected void setRequestMethod() {
        this.requestMethod = "PUT";
    }

    @Override
    protected void setRequestPath() {
        this.requestPath = "/";
    }

    public void setTagList(List<Tag> tagList) {
        if (tagList != null) {
            this.tagging.tagSet.tagList.addAll(tagList);
        }
    }

    public Tagging getTagging() {
        return this.tagging;
    }

    public void setTagList(Tag tag) {
        if (tag != null) {
            this.tagging.tagSet.tagList.add(tag);
        }
    }
}

