/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.utils;

import java.net.URLEncoder;

public class StringUtils {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toHexString(byte[] data) {
        StringBuilder result = new StringBuilder(data.length * 2);
        for (byte b : data) {
            result.append(HEX_DIGITS[(b & 0xF0) >>> 4]);
            result.append(HEX_DIGITS[b & 0xF]);
        }
        return result.toString();
    }

    public static String encodedUrl(String path) {
        String separate = "/";
        String enc = "utf-8";
        String space = "%20";
        if (path == null) {
            return null;
        }
        String[] pathSegment = path.split(separate);
        StringBuilder encodedPath = new StringBuilder();
        try {
            for (String str : pathSegment) {
                if (StringUtils.isEmpty(str)) continue;
                encodedPath.append(URLEncoder.encode(str, enc).replace("+", space)).append(separate);
            }
            if (!path.endsWith(separate)) {
                encodedPath.deleteCharAt(encodedPath.length() - 1);
            }
            if (path.startsWith(separate)) {
                return separate + encodedPath.toString();
            }
            return encodedPath.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getScheme(String url) {
        if (StringUtils.isEmpty(url)) {
            return null;
        }
        String scheme = null;
        String separate = "://";
        int index = url.indexOf(separate);
        if (index != -1) {
            scheme = url.substring(0, index);
        }
        return scheme;
    }

    public static String getHost(String url) {
        if (StringUtils.isEmpty(url)) {
            return null;
        }
        int pos = url.indexOf("://");
        if (pos <= 0) {
            return null;
        }
        int pos2 = url.indexOf(47, pos + 3);
        pos2 = pos2 >= 0 ? pos2 : url.length();
        String host = url.substring(pos + 3, pos2);
        int pos3 = host.indexOf(58);
        if (pos3 >= 0) {
            host = host.substring(0, pos3);
        }
        return host;
    }

    public static long getPort(String url) {
        if (StringUtils.isEmpty(url)) {
            return -1L;
        }
        String host = null;
        int pos = url.indexOf("://");
        if (pos <= 0) {
            return -1L;
        }
        int pos2 = url.indexOf(47, pos + 3);
        pos2 = pos2 >= 0 ? pos2 : url.length();
        host = url.substring(pos + 3, pos2);
        int pos3 = host.indexOf(58);
        long port = -1L;
        if (pos3 >= 0) {
            port = Long.parseLong(host.substring(pos3 + 1, host.length()));
        }
        return port;
    }

    public static String getPath(String url) {
        if (StringUtils.isEmpty(url)) {
            return null;
        }
        String path = null;
        int pos = url.indexOf(47);
        int pos2 = url.indexOf(63);
        if (pos <= 0) {
            return null;
        }
        if (pos >= 0) {
            boolean isSlash;
            boolean bl = isSlash = url.charAt(pos + 1) == '/';
            if (isSlash) {
                pos = url.indexOf(47, pos + 2);
            }
        }
        if (pos >= 0) {
            int end = pos2 >= 0 ? pos2 : url.length();
            path = url.substring(pos, end);
        }
        return path;
    }

    public static String getQuery(String url) {
        if (StringUtils.isEmpty(url)) {
            return null;
        }
        String query = null;
        int pos = url.indexOf(63);
        int pos2 = url.indexOf(35);
        if (pos <= 0) {
            return null;
        }
        if (pos >= 0) {
            int end = pos2 >= 0 ? pos2 : url.length();
            query = url.substring(pos + 1, end);
        }
        return query;
    }

    public static String getFragment(String url) {
        if (StringUtils.isEmpty(url)) {
            return null;
        }
        String fragment = null;
        int pos = url.indexOf(35);
        if (pos <= 0) {
            return null;
        }
        if (pos >= 0) {
            fragment = url.substring(pos + 1);
        }
        return fragment;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

