/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.utils;

import com.tencent.cos.xml.utils.StringUtils;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SHA1Utils {
    public static String getSHA1FromBytes(byte[] data, int offset, int len) throws Exception {
        if (data == null || len <= 0 || offset < 0) {
            throw new IllegalArgumentException("data == null | len <= 0 |offset < 0 |offset >= len");
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(data, offset, len);
            return StringUtils.toHexString(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
    }

    public static String getSHA1FromString(String content) throws Exception {
        try {
            byte[] data = content.getBytes("utf-8");
            return SHA1Utils.getSHA1FromBytes(data, 0, data.length);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getSHA1FromPath(String filePath) throws Exception {
        try (FileInputStream fileInputStream = new FileInputStream(filePath);){
            int len;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] buffer = new byte[65536];
            while ((len = fileInputStream.read(buffer, 0, buffer.length)) != -1) {
                messageDigest.update(buffer, 0, len);
            }
            String string = StringUtils.toHexString(messageDigest.digest());
            return string;
        }
    }
}

