/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import android.util.Log;
import com.tencent.cos.xml.CosXmlService;
import com.tencent.cos.xml.common.ResumeData;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.CosXmlResultListener;
import com.tencent.cos.xml.model.object.AbortMultiUploadRequest;
import com.tencent.cos.xml.model.object.AbortMultiUploadResult;
import com.tencent.cos.xml.model.object.CompleteMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadResult;
import com.tencent.cos.xml.model.object.InitMultipartUploadRequest;
import com.tencent.cos.xml.model.object.InitMultipartUploadResult;
import com.tencent.cos.xml.model.object.ListPartsRequest;
import com.tencent.cos.xml.model.object.ListPartsResult;
import com.tencent.cos.xml.model.object.UploadPartRequest;
import com.tencent.cos.xml.model.object.UploadPartResult;
import com.tencent.cos.xml.model.tag.Part;
import com.tencent.qcloud.network.QCloudProgressListener;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.exception.QCloudExceptionType;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class MultipartUpload {
    private static final String TAG = "MultipartUpload";
    private String cosPath;
    private String srcPath;
    private String uploadId = null;
    private String bucket;
    private Map<Integer, PartStruct> partStructMap;
    private int sliceSize = 0x100000;
    private long fileLength;
    private CosXmlService cosXmlService;
    private ResumeData resumeData;
    private volatile int UPLOAD_PART_COUNT;
    private volatile long ALREADY_SEND_DATA_LEN;
    private volatile int ERROR_EXIT_FLAG;
    private QCloudProgressListener progressListener;
    private byte[] objectSync = new byte[0];
    private CosXmlResult mCosXmlResult;
    private Exception mException;
    private Map<UploadPartRequest, Long> uploadPartRequestLongMap;
    private InitMultipartUploadRequest mInitMultipartUploadRequest;
    private ListPartsRequest mListPartsRequest;
    private CompleteMultiUploadRequest mCompleteMultiUploadRequest;
    private long signExpiredTime = 600L;
    private ExecutorService mExecutorService;

    public MultipartUpload(CosXmlService cosXmlService, ResumeData resumeData) {
        this.cosXmlService = cosXmlService;
        if (resumeData != null) {
            this.resumeData = resumeData;
            this.bucket = resumeData.bucket;
            this.cosPath = resumeData.cosPath;
            this.uploadId = resumeData.uploadId;
            this.srcPath = resumeData.srcPath;
            this.sliceSize = resumeData.sliceSize;
            File file = new File(this.srcPath);
            this.fileLength = file.length();
        } else {
            this.resumeData = new ResumeData();
        }
        this.UPLOAD_PART_COUNT = 0;
        this.ALREADY_SEND_DATA_LEN = 0L;
        this.ERROR_EXIT_FLAG = -1;
        this.partStructMap = new LinkedHashMap<Integer, PartStruct>();
        this.uploadPartRequestLongMap = new LinkedHashMap<UploadPartRequest, Long>();
    }

    public CosXmlService getCosXmlService() {
        return this.cosXmlService;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
        this.resumeData.bucket = bucket;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setCosPath(String cosPath) {
        this.cosPath = cosPath;
        this.resumeData.cosPath = cosPath;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
        this.resumeData.srcPath = srcPath;
    }

    public String getCosPath() {
        return this.cosPath;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public void setSliceSize(int sliceSize) {
        this.sliceSize = sliceSize;
        this.resumeData.sliceSize = sliceSize;
    }

    public long getSliceSize() {
        return this.sliceSize;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public void setProgressListener(QCloudProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public void setSign(long signExpiredTime) {
        this.signExpiredTime = signExpiredTime;
    }

    public QCloudProgressListener getProgressListener() {
        return this.progressListener;
    }

    public CosXmlResult upload2() throws QCloudException {
        this.initPartNumber();
        int httpCode = -1;
        if (this.uploadId == null) {
            InitMultipartUploadResult initMultipartUploadResult = this.initMultiUpload();
            httpCode = initMultipartUploadResult.getHttpCode();
            if (httpCode < 200 || httpCode >= 300) {
                return initMultipartUploadResult;
            }
            this.resumeData.uploadId = this.uploadId = initMultipartUploadResult.initMultipartUpload.uploadId;
        } else {
            Object listPartsResult = this.listPartUpload();
            httpCode = listPartsResult.getHttpCode();
            if (httpCode < 200 || httpCode >= 300) {
                return listPartsResult;
            }
            this.resumeData.uploadId = this.uploadId;
            this.updatePartNumber((ListPartsResult)((Object)listPartsResult));
        }
        for (final Map.Entry entry : this.partStructMap.entrySet()) {
            PartStruct partStruct = (PartStruct)entry.getValue();
            if (partStruct.alreadyUpload) continue;
            Log.w((String)TAG, (String)("partStruct =" + partStruct.toString()));
            this.partUpload(partStruct.partNumber, partStruct.offset, partStruct.sliceSize, new CosXmlResultListener(){

                @Override
                public void onSuccess(CosXmlRequest cosXmlRequest, CosXmlResult cosXmlResult) {
                    ((PartStruct)((MultipartUpload)MultipartUpload.this).partStructMap.get(entry.getKey())).eTag = cosXmlResult.getETag();
                    MultipartUpload.this.UPLOAD_PART_COUNT--;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFail(CosXmlRequest cosXmlRequest, CosXmlResult cosXmlResult) {
                    byte[] byArray = MultipartUpload.this.objectSync;
                    synchronized (byArray) {
                        int httpCode2 = cosXmlResult.getHttpCode();
                        if (httpCode2 < 200 || httpCode2 >= 300) {
                            MultipartUpload.this.mCosXmlResult = cosXmlResult;
                            MultipartUpload.this.ERROR_EXIT_FLAG = 0;
                        } else {
                            MultipartUpload.this.mException = (Exception)((Object)new QCloudException(QCloudExceptionType.getQCloudExceptionType((int)(cosXmlResult.getHttpCode() - 2500)), cosXmlResult.error.message));
                            MultipartUpload.this.ERROR_EXIT_FLAG = 1;
                        }
                    }
                }
            });
        }
        while (this.UPLOAD_PART_COUNT > 0 && this.ERROR_EXIT_FLAG < 0) {
        }
        if (this.ERROR_EXIT_FLAG >= 0) {
            switch (this.ERROR_EXIT_FLAG) {
                case 2: {
                    this.realCancel();
                    throw new QCloudException(QCloudExceptionType.REQUEST_USER_CANCELLED, "request is cancelled by manual cancel");
                }
                case 3: {
                    this.realCancel();
                    throw new QCloudException(QCloudExceptionType.REQUEST_USER_CANCELLED, "request is cancelled by abort request");
                }
                case 0: {
                    this.realCancel();
                    return this.mCosXmlResult;
                }
            }
            this.realCancel();
            if (this.mException != null) {
                throw (QCloudException)((Object)this.mException);
            }
            throw new QCloudException(QCloudExceptionType.UNDEFINE, "unknown exception");
        }
        CompleteMultiUploadResult completeMultiUploadResult = this.completeMultiUpload();
        return completeMultiUploadResult;
    }

    protected InitMultipartUploadResult initMultiUpload() throws QCloudException {
        this.mInitMultipartUploadRequest = new InitMultipartUploadRequest();
        this.mInitMultipartUploadRequest.setCosPath(this.cosPath);
        this.mInitMultipartUploadRequest.setBucket(this.bucket);
        this.mInitMultipartUploadRequest.setSign(this.signExpiredTime, null, null);
        return this.cosXmlService.initMultipartUpload(this.mInitMultipartUploadRequest);
    }

    protected ListPartsResult listPartUpload() throws QCloudException {
        this.mListPartsRequest = new ListPartsRequest();
        this.mListPartsRequest.setBucket(this.bucket);
        this.mListPartsRequest.setCosPath(this.cosPath);
        this.mListPartsRequest.setUploadId(this.uploadId);
        this.mListPartsRequest.setSign(this.signExpiredTime, null, null);
        return this.cosXmlService.listParts(this.mListPartsRequest);
    }

    protected CompleteMultiUploadResult completeMultiUpload() throws QCloudException {
        this.mCompleteMultiUploadRequest = new CompleteMultiUploadRequest();
        this.mCompleteMultiUploadRequest.setBucket(this.bucket);
        this.mCompleteMultiUploadRequest.setUploadId(this.uploadId);
        this.mCompleteMultiUploadRequest.setCosPath(this.cosPath);
        for (Map.Entry<Integer, PartStruct> entry : this.partStructMap.entrySet()) {
            PartStruct partStruct = entry.getValue();
            this.mCompleteMultiUploadRequest.setPartNumberAndETag(partStruct.partNumber, partStruct.eTag);
        }
        this.mCompleteMultiUploadRequest.setSign(this.signExpiredTime, null, null);
        return this.cosXmlService.completeMultiUpload(this.mCompleteMultiUploadRequest);
    }

    protected UploadPartResult partUpload(int partNumber, long offset, long fileContentLength) throws QCloudException {
        final UploadPartRequest uploadPartRequest = new UploadPartRequest();
        uploadPartRequest.setCosPath(this.cosPath);
        uploadPartRequest.setBucket(this.bucket);
        uploadPartRequest.setSign(this.signExpiredTime, null, null);
        uploadPartRequest.setUploadId(this.uploadId);
        uploadPartRequest.setPartNumber(partNumber);
        uploadPartRequest.setSrcPath(this.srcPath, offset, fileContentLength);
        this.uploadPartRequestLongMap.put(uploadPartRequest, 0L);
        uploadPartRequest.setProgressListener(new QCloudProgressListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onProgress(long progress, long max) {
                byte[] byArray = MultipartUpload.this.objectSync;
                synchronized (byArray) {
                    MultipartUpload.this.ALREADY_SEND_DATA_LEN = MultipartUpload.this.ALREADY_SEND_DATA_LEN + (progress - (Long)MultipartUpload.this.uploadPartRequestLongMap.get((Object)uploadPartRequest));
                    MultipartUpload.this.uploadPartRequestLongMap.put(uploadPartRequest, progress);
                    if (MultipartUpload.this.progressListener != null) {
                        MultipartUpload.this.progressListener.onProgress(MultipartUpload.this.ALREADY_SEND_DATA_LEN, MultipartUpload.this.fileLength);
                    }
                }
            }
        });
        return this.cosXmlService.uploadPart(uploadPartRequest);
    }

    protected void partUpload(int partNumber, long offset, long fileContentLength, CosXmlResultListener resultListener) throws QCloudException {
        final UploadPartRequest uploadPartRequest = new UploadPartRequest();
        uploadPartRequest.setCosPath(this.cosPath);
        uploadPartRequest.setBucket(this.bucket);
        uploadPartRequest.setSign(this.signExpiredTime, null, null);
        uploadPartRequest.setUploadId(this.uploadId);
        uploadPartRequest.setPartNumber(partNumber);
        uploadPartRequest.setSrcPath(this.srcPath, offset, fileContentLength);
        this.uploadPartRequestLongMap.put(uploadPartRequest, 0L);
        uploadPartRequest.setProgressListener(new QCloudProgressListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onProgress(long progress, long max) {
                byte[] byArray = MultipartUpload.this.objectSync;
                synchronized (byArray) {
                    MultipartUpload.this.ALREADY_SEND_DATA_LEN = MultipartUpload.this.ALREADY_SEND_DATA_LEN + (progress - (Long)MultipartUpload.this.uploadPartRequestLongMap.get((Object)uploadPartRequest));
                    MultipartUpload.this.uploadPartRequestLongMap.put(uploadPartRequest, progress);
                    if (MultipartUpload.this.progressListener != null) {
                        MultipartUpload.this.progressListener.onProgress(MultipartUpload.this.ALREADY_SEND_DATA_LEN, MultipartUpload.this.fileLength);
                    }
                }
            }
        });
        this.cosXmlService.uploadPartAsync(uploadPartRequest, resultListener);
    }

    protected void initPartNumber() throws QCloudException {
        if (this.srcPath != null) {
            File file = new File(this.srcPath);
            if (!file.exists()) {
                throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "upload file does not exist");
            }
            this.fileLength = file.length();
        }
        if (this.fileLength > 0L && this.sliceSize > 0) {
            PartStruct partStruct;
            int i;
            int count = (int)(this.fileLength / (long)this.sliceSize);
            for (i = 1; i < count; ++i) {
                partStruct = new PartStruct();
                partStruct.partNumber = i;
                partStruct.alreadyUpload = false;
                partStruct.offset = (i - 1) * this.sliceSize;
                partStruct.sliceSize = this.sliceSize;
                this.partStructMap.put(i, partStruct);
            }
            partStruct = new PartStruct();
            partStruct.partNumber = i;
            partStruct.alreadyUpload = false;
            partStruct.offset = (i - 1) * this.sliceSize;
            partStruct.sliceSize = (int)(this.fileLength - partStruct.offset);
            this.partStructMap.put(i, partStruct);
            this.UPLOAD_PART_COUNT = count;
        }
    }

    protected void updatePartNumber(ListPartsResult listPartsResult) {
        if (listPartsResult != null && listPartsResult.listParts != null && listPartsResult.listParts.parts != null) {
            List<Part> list = listPartsResult.listParts.parts;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Part part = list.get(i);
                if (!this.partStructMap.containsKey(part.partNumber)) continue;
                PartStruct partStruct = this.partStructMap.get(part.partNumber);
                partStruct.alreadyUpload = true;
                partStruct.eTag = part.eTag;
                --this.UPLOAD_PART_COUNT;
                this.ALREADY_SEND_DATA_LEN += Long.parseLong(part.size);
            }
        }
    }

    private synchronized void realCancel() {
        if (this.mInitMultipartUploadRequest != null) {
            this.cosXmlService.cancel(this.mInitMultipartUploadRequest);
        }
        this.mInitMultipartUploadRequest = null;
        if (this.mListPartsRequest != null) {
            this.cosXmlService.cancel(this.mListPartsRequest);
        }
        this.mListPartsRequest = null;
        if (this.uploadPartRequestLongMap != null) {
            Set<UploadPartRequest> set = this.uploadPartRequestLongMap.keySet();
            Iterator<UploadPartRequest> iterator = set.iterator();
            while (iterator.hasNext()) {
                this.cosXmlService.cancel(iterator.next());
            }
            this.uploadPartRequestLongMap.clear();
        }
        this.uploadPartRequestLongMap = null;
        if (this.mCompleteMultiUploadRequest != null) {
            this.cosXmlService.cancel(this.mCompleteMultiUploadRequest);
        }
        this.mCompleteMultiUploadRequest = null;
        if (this.partStructMap != null) {
            this.partStructMap.clear();
        }
        this.partStructMap = null;
    }

    public ResumeData cancel() {
        this.ERROR_EXIT_FLAG = 2;
        return this.resumeData;
    }

    public void abortAsync(CosXmlResultListener cosXmlResultListener) {
        this.ERROR_EXIT_FLAG = 3;
        AbortMultiUploadRequest abortMultiUploadRequest = new AbortMultiUploadRequest();
        abortMultiUploadRequest.setBucket(this.bucket);
        abortMultiUploadRequest.setCosPath(this.cosPath);
        abortMultiUploadRequest.setUploadId(this.uploadId);
        abortMultiUploadRequest.setSign(this.signExpiredTime, null, null);
        this.cosXmlService.abortMultiUploadAsync(abortMultiUploadRequest, cosXmlResultListener);
    }

    public AbortMultiUploadResult abort() throws QCloudException {
        this.ERROR_EXIT_FLAG = 3;
        AbortMultiUploadRequest abortMultiUploadRequest = new AbortMultiUploadRequest();
        abortMultiUploadRequest.setBucket(this.bucket);
        abortMultiUploadRequest.setCosPath(this.cosPath);
        abortMultiUploadRequest.setUploadId(this.uploadId);
        abortMultiUploadRequest.setSign(this.signExpiredTime, null, null);
        return this.cosXmlService.abortMultiUpload(abortMultiUploadRequest);
    }

    protected class PartStruct {
        public int partNumber;
        public boolean alreadyUpload;
        public String eTag;
        public long offset;
        public long sliceSize;

        protected PartStruct() {
        }

        public String toString() {
            return "{partNumber :" + this.partNumber + ",alreadyUpload :" + this.alreadyUpload + ",eTag :" + this.eTag + ",offset :" + this.offset + ",sliceSize :" + this.sliceSize + "}";
        }
    }
}

