/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import android.support.annotation.NonNull;
import com.tencent.cos.xml.common.COSACL;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.object.PutObjectResult;
import com.tencent.qcloud.network.QCloudProgressListener;
import com.tencent.qcloud.network.QCloudRequest;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.exception.QCloudExceptionType;
import com.tencent.qcloud.network.request.serializer.body.RequestByteArraySerializer;
import com.tencent.qcloud.network.request.serializer.body.RequestFileBodySerializer;
import com.tencent.qcloud.network.request.serializer.body.RequestStreamBodySerializer;
import com.tencent.qcloud.network.response.serializer.body.ResponseXmlS3BodySerializer;
import com.tencent.qcloud.network.response.serializer.http.HttpPassAllSerializer;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class PutObjectRequest
extends CosXmlRequest {
    private String cosPath;
    private String srcPath;
    private byte[] data;
    private InputStream inputStream;
    private long fileLength;
    private QCloudProgressListener progressListener;

    public PutObjectRequest() {
        this.contentType = "text/plain";
        this.requestHeaders.put("Content-Type", this.contentType);
    }

    public void build() {
        this.priority = QCloudRequest.QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_LOW;
        this.setRequestMethod();
        this.requestOriginBuilder.method(this.requestMethod);
        this.setRequestPath();
        this.requestOriginBuilder.pathAddRear(this.requestPath);
        this.requestOriginBuilder.hostAddFront(this.bucket);
        this.setRequestQueryParams();
        if (this.requestQueryParams.size() > 0) {
            for (Map.Entry entry : this.requestQueryParams.entrySet()) {
                this.requestOriginBuilder.query((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.requestHeaders.size() > 0) {
            for (Map.Entry entry : this.requestHeaders.entrySet()) {
                this.requestOriginBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.srcPath != null) {
            RequestFileBodySerializer requestFileBodySerializer = new RequestFileBodySerializer(this.srcPath, "text/plain");
            requestFileBodySerializer.setProgressListener(this.progressListener);
            this.requestBodySerializer = requestFileBodySerializer;
        } else if (this.data != null) {
            RequestByteArraySerializer requestByteArraySerializer = new RequestByteArraySerializer(this.data, "text/plain");
            requestByteArraySerializer.setProgressListener(this.progressListener);
            this.requestBodySerializer = requestByteArraySerializer;
        } else if (this.inputStream != null) {
            RequestStreamBodySerializer requestStreamBodySerializer = new RequestStreamBodySerializer(this.inputStream, this.fileLength, "text/plain");
            requestStreamBodySerializer.setProgressListener(this.progressListener);
            this.requestBodySerializer = requestStreamBodySerializer;
        }
        this.responseSerializer = new HttpPassAllSerializer();
        this.responseBodySerializer = new ResponseXmlS3BodySerializer(PutObjectResult.class);
    }

    @Override
    protected void setRequestQueryParams() {
    }

    @Override
    public void checkParameters() throws QCloudException {
        File file;
        if (this.bucket == null) {
            throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "bucket must not be null");
        }
        if (this.cosPath == null) {
            throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "cosPath must not be null");
        }
        if (this.srcPath == null && this.data == null && this.inputStream == null) {
            throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "Data Source must not be null");
        }
        if (this.srcPath != null && !(file = new File(this.srcPath)).exists()) {
            throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "upload file does not exist");
        }
    }

    @Override
    protected void setRequestMethod() {
        this.requestMethod = "PUT";
    }

    @Override
    protected void setRequestPath() {
        if (this.cosPath != null) {
            this.requestPath = !this.cosPath.startsWith("/") ? "/" + this.cosPath : this.cosPath;
        }
    }

    public void setProgressListener(QCloudProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public QCloudProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setCosPath(String cosPath) {
        this.cosPath = cosPath;
    }

    public String getCosPath() {
        return this.cosPath;
    }

    public void setSrcPath(@NonNull String srcPath) {
        this.srcPath = srcPath;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public void setCacheControl(String cacheControl) {
        if (cacheControl == null) {
            return;
        }
        this.requestHeaders.put("Cache-Control", cacheControl);
    }

    public void setContentDisposition(String contentDisposition) {
        if (contentDisposition == null) {
            return;
        }
        this.requestHeaders.put("Content-Disposition", contentDisposition);
    }

    public void setContentEncodeing(String contentEncodeing) {
        if (contentEncodeing == null) {
            return;
        }
        this.requestHeaders.put("Content-Encoding", contentEncodeing);
    }

    public void setExpires(String expires) {
        if (expires == null) {
            return;
        }
        this.requestHeaders.put("Expires", expires);
    }

    public void setXCOSMeta(String key, String value) {
        if (key != null && value != null) {
            this.requestHeaders.put(key, value);
        }
    }

    public void setXCOSACL(COSACL xCOSACL) {
        if (xCOSACL != null) {
            this.requestHeaders.put("x-cos-acl", xCOSACL.getACL());
        }
    }

    public void setXCOSACL(String xCOSACL) {
        if (xCOSACL != null) {
            this.requestHeaders.put("x-cos-acl", xCOSACL);
        }
    }

    public void setXCOSGrantReadWithUIN(List<String> uinList) {
        this.setXCOSGrant(uinList, 1, 0);
    }

    public void setXCOSGrantRead(List<String> idList) {
        this.setXCOSGrant(idList, 0, 0);
    }

    public void setXCOSGrantWriteWithUIN(List<String> uinList) {
        this.setXCOSGrant(uinList, 1, 1);
    }

    public void setXCOSGrantWrite(List<String> idList) {
        this.setXCOSGrant(idList, 0, 1);
    }

    public void setXCOSReadWriteWithUIN(List<String> uinList) {
        this.setXCOSGrant(uinList, 1, 2);
    }

    public void setXCOSReadWrite(List<String> idList) {
        this.setXCOSGrant(idList, 0, 2);
    }

    private String getXCOSGrantForId(List<String> idList) {
        if (idList != null) {
            int size = idList.size();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < size - 1; ++i) {
                stringBuilder.append("id=\"qcs::cam::").append(idList.get(i)).append("\"").append(",");
            }
            stringBuilder.append("id=\"qcs::cam::").append(idList.get(size - 1)).append("\"");
            return stringBuilder.toString();
        }
        return null;
    }

    private String getXCOSGrantForUIN(List<String> uinList) {
        if (uinList != null) {
            int size = uinList.size();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < size - 1; ++i) {
                stringBuilder.append("uin=").append("\"").append(uinList.get(i)).append("\"").append(",");
            }
            stringBuilder.append("uin=").append("\"").append(uinList.get(size - 1)).append("\"");
            return stringBuilder.toString();
        }
        return null;
    }

    private void setXCOSGrant(List<String> list, int idType, int grantType) {
        if (list != null) {
            String grantMsg = null;
            if (idType == 0) {
                grantMsg = this.getXCOSGrantForUIN(list);
            } else if (idType == 1) {
                grantMsg = this.getXCOSGrantForId(list);
            }
            switch (grantType) {
                case 0: {
                    this.requestHeaders.put("x-cos-grant-read", grantMsg);
                    break;
                }
                case 1: {
                    this.requestHeaders.put("x-cos-grant-write", grantMsg);
                    break;
                }
                case 2: {
                    this.requestHeaders.put("x-cos-grant-full-control", grantMsg);
                }
            }
        }
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setInputStream(InputStream inputStream, long fileLength) {
        this.inputStream = inputStream;
        this.fileLength = fileLength;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public long getFileLength() {
        return this.fileLength;
    }
}

