/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.tools;

import android.util.Log;
import com.tencent.qcloud.network.tools.TimeUtils;

public class Record {
    private String tag = null;
    private String msg = null;
    private Throwable throwable = null;
    private String level = null;
    private long timestamp;
    private long threadId;
    private String threadName = null;

    public Record(String tag, String level, String msg, Throwable t) {
        this.level = level;
        this.tag = tag;
        this.msg = msg;
        this.throwable = t;
        this.timestamp = System.currentTimeMillis();
        this.threadId = Thread.currentThread().getId();
        this.threadName = Thread.currentThread().getName();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.level).append("/");
        builder.append(TimeUtils.timeUtils(this.timestamp, "yyyy-MM-dd HH:mm:ss"));
        builder.append("[").append(this.threadName).append(" ").append(this.threadId).append("]");
        builder.append("[").append(this.tag).append("]");
        builder.append("[").append(this.msg).append("]");
        if (this.throwable != null) {
            builder.append(" * Exception :\n").append(Log.getStackTraceString((Throwable)this.throwable));
        }
        builder.append("\n");
        return builder.toString();
    }

    public long getLength() {
        return (this.msg != null ? this.msg.length() : 0) + 40;
    }
}

