/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.response.serializer.body;

import com.tencent.qcloud.network.QCloudResult;
import com.tencent.qcloud.network.annotation.SequenceFieldKeySorter;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.logger.QCloudLogger;
import com.tencent.qcloud.network.response.serializer.body.ResponseBodySerializer;
import com.tencent.qcloud.network.response.serializer.body.ResponseSerializerHelper;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import com.thoughtworks.xstream.converters.reflection.FieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import java.io.IOException;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseXmlBodySerializer
implements ResponseBodySerializer {
    private Logger logger = LoggerFactory.getLogger(ResponseXmlBodySerializer.class);
    private Class cls;

    public ResponseXmlBodySerializer(Class cls) {
        this.cls = cls;
    }

    @Override
    public QCloudResult serialize(Response response) throws QCloudException {
        if (response == null) {
            return null;
        }
        if (response.body() != null) {
            try {
                String xmlString = response.body().string();
                XStream xStream = new XStream((ReflectionProvider)new PureJavaReflectionProvider(new FieldDictionary((FieldKeySorter)new SequenceFieldKeySorter())));
                QCloudLogger.debug(this.logger, xmlString);
                xStream.processAnnotations(this.cls);
                QCloudLogger.debug(this.logger, xStream.fromXML(xmlString).toString());
                return (QCloudResult)xStream.fromXML(xmlString);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ResponseSerializerHelper.noBodyResult(this.cls, response);
    }
}

