/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.response.serializer.body;

import com.tencent.qcloud.network.QCloudProgressListener;
import com.tencent.qcloud.network.QCloudResult;
import com.tencent.qcloud.network.assist.ContentRange;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.exception.QCloudExceptionType;
import com.tencent.qcloud.network.response.serializer.body.ResponseBodySerializer;
import com.tencent.qcloud.network.response.serializer.body.ResponseSerializerHelper;
import com.tencent.qcloud.network.tools.QCloudStringTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ResponseFileSerializer
implements ResponseBodySerializer {
    private String downloadPath;
    private Class cls;
    private QCloudProgressListener progressListener;

    public ResponseFileSerializer(String downloadPath, Class cls) {
        this.downloadPath = downloadPath;
        this.cls = cls;
    }

    @Override
    public QCloudResult serialize(Response response) throws QCloudException {
        if (response == null) {
            return null;
        }
        ResponseBody responseBody = response.body();
        String contentRangeString = response.header("Content-Range");
        ContentRange contentRange = QCloudStringTools.contentRange(contentRangeString);
        long hasRead = 0L;
        long max = 0L;
        if (contentRange != null) {
            max = contentRange.getEnd() - contentRange.getStart() + 1L;
        }
        if (responseBody != null) {
            InputStream inputStream = responseBody.byteStream();
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(new File(this.downloadPath));
                byte[] buffer = new byte[2048];
                int len = 0;
                while ((len = inputStream.read(buffer)) != -1) {
                    fileOutputStream.write(buffer, 0, len);
                    hasRead += (long)len;
                    if (this.progressListener == null || max == 0L) continue;
                    this.progressListener.onProgress(hasRead, max);
                }
                fileOutputStream.flush();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new QCloudException(QCloudExceptionType.WRITE_READ_LOCAL_FILE_FAILED, "down load local path not exist.");
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new QCloudException(QCloudExceptionType.WRITE_READ_LOCAL_FILE_FAILED, "write down load file to local failed");
            }
            finally {
                try {
                    inputStream.close();
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                responseBody.close();
            }
        }
        return ResponseSerializerHelper.noBodyResult(this.cls, response);
    }

    public void setProgressListener(QCloudProgressListener progressListener) {
        this.progressListener = progressListener;
    }
}

