/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.response.serializer.body;

import com.tencent.qcloud.network.QCloudProgressListener;
import com.tencent.qcloud.network.QCloudResult;
import com.tencent.qcloud.network.assist.ContentRange;
import com.tencent.qcloud.network.assist.Range;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.exception.QCloudExceptionType;
import com.tencent.qcloud.network.logger.QCloudLogger;
import com.tencent.qcloud.network.response.serializer.body.ResponseBodySerializer;
import com.tencent.qcloud.network.response.serializer.body.ResponseSerializerHelper;
import com.tencent.qcloud.network.tools.QCloudStringTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseFilePartSerializer
implements ResponseBodySerializer {
    private Logger logger = LoggerFactory.getLogger(ResponseFilePartSerializer.class);
    private String downloadPath;
    private Class cls;
    private QCloudProgressListener progressListener;
    private Range range;

    public ResponseFilePartSerializer(String downloadPath, Range range, Class cls) {
        this.downloadPath = downloadPath;
        this.range = range;
        this.cls = cls;
    }

    @Override
    public QCloudResult serialize(Response response) throws QCloudException {
        if (response == null) {
            return null;
        }
        ResponseBody responseBody = response.body();
        String contentRangeString = response.header("Content-Range");
        ContentRange remoteContentRange = QCloudStringTools.contentRange(contentRangeString);
        long hasRead = 0L;
        long max = 0L;
        if (remoteContentRange != null) {
            max = remoteContentRange.getEnd() - remoteContentRange.getStart() + 1L;
            if (this.range.getStart() != remoteContentRange.getStart() || this.range.getEnd() != remoteContentRange.getEnd()) {
                QCloudLogger.warn(this.logger, "local content range is {}, remote content range is {}", this.range, remoteContentRange);
            }
        }
        if (responseBody != null) {
            InputStream inputStream = responseBody.byteStream();
            RandomAccessFile fileOutputStream = null;
            try {
                fileOutputStream = new RandomAccessFile(new File(this.downloadPath), "rws");
                QCloudLogger.warn(this.logger, "savePath is {}", this.downloadPath);
                fileOutputStream.seek(this.range.getStart());
                byte[] buffer = new byte[2048];
                int len = 0;
                while ((len = inputStream.read(buffer)) != -1) {
                    fileOutputStream.write(buffer, 0, len);
                    hasRead += (long)len;
                    if (this.progressListener == null || max == 0L) continue;
                    this.progressListener.onProgress(hasRead, max);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new QCloudException(QCloudExceptionType.WRITE_READ_LOCAL_FILE_FAILED, "down load local path not exist.");
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new QCloudException(QCloudExceptionType.WRITE_READ_LOCAL_FILE_FAILED, "write down load file to local failed");
            }
            finally {
                try {
                    inputStream.close();
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                responseBody.close();
            }
        }
        return ResponseSerializerHelper.noBodyResult(this.cls, response);
    }

    public void setProgressListener(QCloudProgressListener progressListener) {
        this.progressListener = progressListener;
    }
}

