/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network;

import android.content.Context;
import com.tencent.qcloud.network.QCloudHttpRequest;
import com.tencent.qcloud.network.QCloudRequestManager;
import com.tencent.qcloud.network.QCloudServiceConfig;
import com.tencent.qcloud.network.action.QCloudSignatureAction;
import com.tencent.qcloud.network.auth.QCloudCredentialProvider;
import com.tencent.qcloud.network.exception.QCloudException;

public abstract class QCloudService {
    protected QCloudRequestManager requestManager;
    protected QCloudServiceConfig serviceConfig;
    protected QCloudCredentialProvider credentialProvider;

    public QCloudService(Context context, QCloudServiceConfig serviceConfig, QCloudCredentialProvider cloudCredentialProvider) {
        this.credentialProvider = cloudCredentialProvider;
        this.serviceConfig = serviceConfig;
        this.requestManager = new QCloudRequestManager(context, serviceConfig);
    }

    protected void buildRequest(QCloudHttpRequest request) throws QCloudException {
        request.getRequestOriginBuilder().scheme(this.serviceConfig.getHttpProtocol());
        request.getRequestOriginBuilder().hostAddFront(this.serviceConfig.getHttpHost());
        request.getRequestOriginBuilder().header("User-Agent", this.serviceConfig.getUserAgent());
        request.setSignatureAction(new QCloudSignatureAction(request, this.credentialProvider));
        request.build();
    }

    public QCloudServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }
}

