/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network;

import android.content.Context;
import com.tencent.qcloud.network.HttpRequestSerializerListener;
import com.tencent.qcloud.network.QCloudHttpRequest;
import com.tencent.qcloud.network.QCloudRequest;
import com.tencent.qcloud.network.QCloudRequestBuffer;
import com.tencent.qcloud.network.QCloudResult;
import com.tencent.qcloud.network.QCloudResultListener;
import com.tencent.qcloud.network.QCloudServiceConfig;
import com.tencent.qcloud.network.action.QCloudActionManager;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.exception.QCloudExceptionType;
import com.tencent.qcloud.network.logger.QCloudLogger;
import com.tencent.qcloud.network.retry.NetworkConnectionRetryHandler;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QCloudRequestManager {
    private static final Logger logger = LoggerFactory.getLogger(QCloudRequestManager.class);
    final QCloudRequestBuffer requestBuffer;
    private final QCloudActionManager actionManager;
    private final int maxOkHttpRequestConcurrentNumber;
    private int httpConnectTimeout;
    private int httpReadTimeout;
    private int httpWriteTimeout;
    private OkHttpClient okHttpClient;
    private String verifyHost;
    public static Context context = null;
    private final QCloudServiceConfig serviceConfig;

    public QCloudRequestManager(Context context, QCloudServiceConfig config) {
        QCloudRequestManager.context = context;
        this.verifyHost = config.getHttpHost();
        this.requestBuffer = new QCloudRequestBuffer(config.getMaxLowPriorityRequestConcurrent(), config.getMaxNormalPriorityRequestConcurrent(), config.getMaxRequestConcurrentNumber());
        this.maxOkHttpRequestConcurrentNumber = config.getMaxRequestConcurrentNumber();
        this.httpConnectTimeout = config.getConnectionTimeout();
        this.httpReadTimeout = config.getSocketTimeout();
        this.httpWriteTimeout = config.getSocketTimeout();
        this.serviceConfig = config;
        this.actionManager = new QCloudActionManager(config.getMaxActionConcurrent());
        this.initOkHttpClient();
    }

    private void initOkHttpClient() {
        if (this.okHttpClient == null) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder().followRedirects(false).followSslRedirects(false).retryOnConnectionFailure(false).cache(null).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return HttpsURLConnection.getDefaultHostnameVerifier().verify(QCloudRequestManager.this.verifyHost, session);
                }
            });
            Dispatcher dispatcher = new Dispatcher();
            dispatcher.setMaxRequestsPerHost(this.maxOkHttpRequestConcurrentNumber);
            dispatcher.setMaxRequests(this.maxOkHttpRequestConcurrentNumber);
            builder.connectTimeout((long)this.httpConnectTimeout, TimeUnit.MILLISECONDS).readTimeout((long)this.httpReadTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)this.httpWriteTimeout, TimeUnit.MILLISECONDS).dispatcher(dispatcher);
            if (this.serviceConfig.getMaxRetryCount() > 0) {
                builder.addInterceptor((Interceptor)new NetworkConnectionRetryHandler(this.serviceConfig.getMaxRetryCount()));
            }
            this.okHttpClient = builder.build();
        }
    }

    public void send(QCloudHttpRequest request, QCloudResultListener resultListener) {
        request.setResultListener(resultListener);
        this.requestBuffer.add(request);
        this.promoteSend();
    }

    private void promoteSend() {
        QCloudHttpRequest sendRequest;
        while ((sendRequest = this.requestBuffer.next()) != null && !sendRequest.isCancelled()) {
            if (!sendRequest.httpStart()) {
                QCloudLogger.warn(logger, "your request can't be execute anymore.");
                return;
            }
            QCloudLogger.debug(logger, "your request is prepare to send.");
            sendRequest.serialize(this.actionManager, this.serviceConfig, new HttpRequestSerializerListener(){

                @Override
                public void onSuccess(QCloudHttpRequest request) {
                    QCloudLogger.info(logger, "block task success, will go to real send.");
                    if (!sendRequest.isCancelled()) {
                        QCloudRequestManager.this.realSend(request);
                    } else {
                        QCloudLogger.info(logger, String.format(Locale.ENGLISH, "the request %d has cancelled.", request.getRequestId()));
                    }
                }

                @Override
                public void onFailed(QCloudHttpRequest request, QCloudException exception) {
                    QCloudLogger.info(logger, "block task failed");
                }
            });
        }
    }

    private void realSend(final QCloudHttpRequest request) {
        Call call = null;
        if (request.httpRequest != null) {
            call = this.okHttpClient.newCall(request.httpRequest);
        }
        if (call == null) {
            QCloudLogger.info(logger, "your request can't to send.");
            return;
        }
        request.setCall(call);
        QCloudLogger.debug(logger, request.httpRequest.url().toString());
        QCloudLogger.debug(logger, request.httpRequest.headers().toString());
        QCloudLogger.debug(logger, "request enqueue");
        request.getCall().enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
                QCloudResultListener resultListener = request.getResultListener();
                if (resultListener != null) {
                    resultListener.onFail(request, new QCloudException(QCloudExceptionType.REQUEST_EXECUTE_FAILED, e.getMessage()));
                }
                QCloudRequestManager.this.requestBuffer.remove(request);
                QCloudRequestManager.this.promoteSend();
            }

            public void onResponse(Call call, Response response) throws IOException {
                String headers = response.request().headers().toString();
                System.out.println(headers);
                QCloudResultListener resultListener = request.getResultListener();
                if (resultListener != null) {
                    QCloudResult result = null;
                    boolean next = request.getResponseSerializer().serialize(response);
                    if (next) {
                        try {
                            result = request.getResponseBodySerializer().serialize(response);
                        }
                        catch (QCloudException e) {
                            e.printStackTrace();
                            throw new IOException(e.getDetailMessage(), e);
                        }
                        if (result != null) {
                            result.setHttpCode(response.code());
                            result.setHttpMessage(response.message());
                            result.setHeaders(response.headers().toMultimap());
                        }
                    }
                    resultListener.onSuccess(request, result);
                    if (response.body() != null) {
                        response.body().close();
                    }
                }
                QCloudRequestManager.this.requestBuffer.remove(request);
                QCloudRequestManager.this.promoteSend();
            }
        });
    }

    public QCloudResult send(QCloudHttpRequest request) throws QCloudException {
        final ResponseHolder responseHolder = new ResponseHolder();
        this.send(request, new QCloudResultListener(){

            @Override
            public synchronized void onSuccess(QCloudRequest request, QCloudResult result) {
                responseHolder.setResponse(result);
                request.finishBlock();
            }

            @Override
            public synchronized void onFail(QCloudRequest request, QCloudException exception) {
                responseHolder.setQCloudException(exception);
                request.finishBlock();
            }
        });
        try {
            request.startBlock();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (responseHolder.getQCloudException() != null) {
            throw responseHolder.getQCloudException();
        }
        return responseHolder.getResponse();
    }

    public boolean cancel(QCloudHttpRequest request) {
        if (request == null) {
            QCloudLogger.warn(logger, "you can't cancel a null request.");
            return false;
        }
        if (!this.requestBuffer.remove(request)) {
            QCloudLogger.warn(logger, String.format(Locale.ENGLISH, "the request %d no exist in buffer.", request.getRequestId()));
            return false;
        }
        if (!request.httpCancel()) {
            QCloudLogger.warn(logger, String.format(Locale.ENGLISH, "the request %d has cancelled before.", request.getRequestId()));
            return false;
        }
        QCloudLogger.debug(logger, String.format(Locale.ENGLISH, "the request %d has cancel success.", request.getRequestId()));
        return true;
    }

    public void cancelAll() {
        List<QCloudHttpRequest> requests = this.requestBuffer.list();
        for (QCloudHttpRequest request : requests) {
            this.cancel(request);
        }
    }

    public void release() {
        this.cancelAll();
        this.actionManager.release();
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    private static class ResponseHolder {
        QCloudResult response;
        QCloudException qCloudException;

        private ResponseHolder() {
        }

        public void setResponse(QCloudResult response) {
            this.response = response;
        }

        public QCloudResult getResponse() {
            return this.response;
        }

        public synchronized void setQCloudException(QCloudException qCloudException) {
            this.qCloudException = qCloudException;
        }

        public synchronized QCloudException getQCloudException() {
            return this.qCloudException;
        }
    }
}

