/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.utils;

import android.util.Log;
import com.tencent.cos.xml.utils.StringUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SHA1Utils {
    public static String getSHA1FromBytes(byte[] data, int offset, int len) {
        if (data == null || len <= 0 || offset < 0) {
            Log.e((String)"SHA1Utils", (String)"data == null | len <= 0 | offset < 0 |offset >= len");
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(data, offset, len);
            return StringUtils.toHexString(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            Log.e((String)"SHA1Utils", (String)"no such algorithm");
            e.printStackTrace();
        }
        catch (OutOfMemoryError e) {
            Log.e((String)"SHA1Utils", (String)"OutOfMemoryError");
            e.printStackTrace();
        }
        return null;
    }

    public static String getSHA1FromString(String content) {
        try {
            byte[] data = content.getBytes("utf-8");
            return SHA1Utils.getSHA1FromBytes(data, 0, data.length);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSHA1FromPath(String filePath) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(filePath);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] buffer = new byte[65536];
            int len = 0;
            while ((len = fileInputStream.read(buffer, 0, buffer.length)) != -1) {
                messageDigest.update(buffer, 0, len);
            }
            String string = StringUtils.toHexString(messageDigest.digest());
            return string;
        }
        catch (FileNotFoundException e) {
            Log.e((String)"SHA1Utils", (String)"FileNotFoundException");
            e.printStackTrace();
        }
        catch (IOException e) {
            Log.e((String)"SHA1Utils", (String)"IOException");
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            Log.e((String)"SHA1Utils", (String)"NoSuchAlgorithmException");
            e.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

