/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.sign;

import com.tencent.cos.xml.sign.CosXmlConst;
import com.tencent.qcloud.network.QCloudHttpRequest;
import com.tencent.qcloud.network.auth.KeyValuesHelper;
import com.tencent.qcloud.network.auth.QCloudSignatureSourceSerializer;
import com.tencent.qcloud.network.logger.QCloudLogger;
import com.tencent.qcloud.network.tools.DigestUtils;
import com.tencent.qcloud.network.tools.HexUtils;
import com.tencent.qcloud.network.tools.QCloudSetTools;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosXmlSignatureSourceSerializer
implements QCloudSignatureSourceSerializer {
    private Logger logger = LoggerFactory.getLogger(CosXmlSignatureSourceSerializer.class);
    private QCloudHttpRequest httpRequest;
    private Set<String> paras;
    private Set<String> realSignParas;
    private Set<String> realSignHeader;
    private Set<String> headers;
    private long duration;
    private String signTime;

    public CosXmlSignatureSourceSerializer(long duration) {
        this.duration = duration;
        this.headers = new HashSet<String>();
        this.paras = new HashSet<String>();
        this.realSignHeader = new HashSet<String>();
        this.realSignParas = new HashSet<String>();
    }

    public void parameter(String key) {
        this.paras.add(key);
    }

    public void parameters(Set<String> keys) {
        this.paras.addAll(keys);
    }

    public void header(String key) {
        this.headers.add(key);
        QCloudLogger.debug(this.logger, "headers now is {}", this.headers);
    }

    public void headers(Set<String> keys) {
        this.headers.addAll(keys);
    }

    public String source() {
        if (this.httpRequest == null) {
            return null;
        }
        QCloudLogger.debug(this.logger, "source serializer is {}", this);
        Request request = this.httpRequest.getHttpRequest();
        if (this.headers != null && this.headers.size() > 0) {
            MediaType contentType;
            Set<String> lowerCaseHeaders = QCloudSetTools.getLowerCase(this.headers);
            Request.Builder requestBuilder = request.newBuilder();
            RequestBody requestBody = request.body();
            if (lowerCaseHeaders.contains("Content-Type".toLowerCase()) && requestBody != null && (contentType = requestBody.contentType()) != null) {
                requestBuilder.header("Content-Type", contentType.toString());
            }
            if (lowerCaseHeaders.contains("Content-Length".toLowerCase()) && requestBody != null) {
                long contentLength = -1L;
                try {
                    contentLength = requestBody.contentLength();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (contentLength != -1L) {
                    requestBuilder.header("Content-Length", Long.toString(contentLength));
                    requestBuilder.removeHeader("Transfer-Encoding");
                } else {
                    requestBuilder.header("Transfer-Encoding", "chunked");
                    requestBuilder.removeHeader("Content-Length");
                }
            }
            if (lowerCaseHeaders.contains("Date".toLowerCase())) {
                Date d = new Date();
                SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("GMT"));
                System.out.println(format.format(d));
                requestBuilder.header("Date", format.format(d));
            }
            request = requestBuilder.build();
        }
        this.httpRequest.setHttpRequest(request);
        QCloudLogger.debug(this.logger, "method is {}", request.method());
        StringBuilder formatString = new StringBuilder(request.method().toLowerCase());
        formatString.append("\n");
        String path = null;
        try {
            path = URLDecoder.decode(request.url().url().getPath(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        QCloudLogger.debug(this.logger, "path is {}", path);
        formatString.append(path);
        formatString.append("\n");
        QCloudLogger.debug(this.logger, "query parameter is {}", request.url().query());
        QCloudLogger.debug(this.logger, "sign parameter is {}", this.paras.toString());
        String paraString = KeyValuesHelper.queryStringForKeys(request.url(), this.paras, this.realSignParas);
        if (paraString == null) {
            paraString = "";
        }
        formatString.append(paraString);
        formatString.append("\n");
        QCloudLogger.debug(this.logger, "parameter string is {}", paraString);
        QCloudLogger.debug(this.logger, "header is {}", request.headers().toString());
        QCloudLogger.debug(this.logger, "sign header is {}", this.headers.toString());
        String headerString = KeyValuesHelper.headersStringForKeys(request.headers(), this.headers, this.realSignHeader);
        if (headerString == null) {
            headerString = "";
        }
        formatString.append(headerString);
        formatString.append("\n");
        QCloudLogger.debug(this.logger, "header string is {}", headerString);
        QCloudLogger.debug(this.logger, "final formatString is {}", formatString);
        StringBuilder stringToSign = new StringBuilder();
        stringToSign.append(CosXmlConst.SHA1);
        stringToSign.append("\n");
        QCloudLogger.debug(this.logger, "StringToSign is {}", stringToSign.toString());
        long currentTime = System.currentTimeMillis() / 1000L;
        long expiredTime = currentTime + this.duration;
        this.signTime = currentTime + ";" + expiredTime;
        stringToSign.append(this.signTime);
        stringToSign.append("\n");
        QCloudLogger.debug(this.logger, "StringToSign is {}", stringToSign.toString());
        String formatStringSha1 = new String(HexUtils.encodeHex(DigestUtils.sha1(formatString.toString())));
        stringToSign.append(formatStringSha1);
        stringToSign.append("\n");
        QCloudLogger.debug(this.logger, "StringToSign is {}", stringToSign.toString());
        return stringToSign.toString();
    }

    public void setHttpRequest(QCloudHttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public String getRealHeaderList() {
        return QCloudSetTools.joinSemicolon(this.realSignHeader);
    }

    public String getRealParameterList() {
        return QCloudSetTools.joinSemicolon(this.realSignParas);
    }

    public String getSignTime() {
        return this.signTime;
    }
}

