/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.sign;

import com.tencent.qcloud.network.auth.QCloudSignatureSourceEncryptor;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.logger.QCloudLogger;
import com.tencent.qcloud.network.tools.HexUtils;
import com.tencent.qcloud.network.tools.QCloudStringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosXmlSignatureSourceEncryptor
implements QCloudSignatureSourceEncryptor {
    private Logger logger = LoggerFactory.getLogger(CosXmlSignatureSourceEncryptor.class);
    private String keyTime;
    private String signKey;

    public CosXmlSignatureSourceEncryptor(String signKey, String keyTime) {
        this.signKey = signKey;
        this.keyTime = keyTime;
    }

    public String signature(String source) throws QCloudException {
        QCloudLogger.debug(this.logger, "source is \r\n{}", source);
        QCloudLogger.debug(this.logger, "sign key is {}", this.signKey);
        byte[] sha1Bytes = QCloudStringTools.hmacSha1(source, this.signKey);
        String signature = "";
        if (sha1Bytes != null) {
            signature = new String(HexUtils.encodeHex(sha1Bytes));
        }
        QCloudLogger.debug(this.logger, "signature is {}", signature);
        return signature;
    }

    public String getKeyTime() {
        return this.keyTime;
    }

    public String getSignKey() {
        return this.signKey;
    }

    public void setSignKey(String signKey) {
        this.signKey = signKey;
    }

    public void setKeyTime(String keyTime) {
        this.keyTime = keyTime;
    }
}

