/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.sign;

import com.tencent.cos.xml.sign.CosXmlConst;
import com.tencent.cos.xml.sign.CosXmlSignaturePair;
import com.tencent.cos.xml.sign.CosXmlSignatureSourceEncryptor;
import com.tencent.cos.xml.sign.CosXmlSignatureSourceSerializer;
import com.tencent.qcloud.network.QCloudHttpRequest;
import com.tencent.qcloud.network.auth.QCloudCredentialProvider;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.logger.QCloudLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CosXmlCredentialProvider
extends QCloudCredentialProvider {
    private Logger logger = LoggerFactory.getLogger(CosXmlCredentialProvider.class);
    private String secretId;

    public CosXmlCredentialProvider(String secretId) {
        this.secretId = secretId;
    }

    public abstract CosXmlSignaturePair signaturePair() throws QCloudException;

    @Override
    public String signature(QCloudHttpRequest httpRequest) throws QCloudException {
        CosXmlSignaturePair signaturePair = this.signaturePair();
        this.sourceEncryptor = new CosXmlSignatureSourceEncryptor(signaturePair.getSignKey(), signaturePair.getKeyTime());
        this.sourceSerializer = httpRequest.getSourceSerializer();
        if (this.sourceSerializer == null) {
            QCloudLogger.debug(this.logger, "source serializer is null");
            return "";
        }
        QCloudLogger.debug(this.logger, "source serializer is not null");
        CosXmlSignatureSourceSerializer xmlSourceSerializer = (CosXmlSignatureSourceSerializer)this.sourceSerializer;
        CosXmlSignatureSourceEncryptor xmlSourceEncryptor = (CosXmlSignatureSourceEncryptor)this.sourceEncryptor;
        xmlSourceSerializer.setHttpRequest(httpRequest);
        StringBuilder authorization = new StringBuilder();
        String signature = xmlSourceEncryptor.signature(xmlSourceSerializer.source());
        authorization.append(CosXmlConst.Q_SIGN_ALGORITHM).append("=").append(CosXmlConst.SHA1).append("&").append(CosXmlConst.Q_AK).append("=").append(this.secretId).append("&").append(CosXmlConst.Q_SIGN_TIME).append("=").append(xmlSourceSerializer.getSignTime()).append("&").append(CosXmlConst.Q_KEY_TIME).append("=").append(xmlSourceEncryptor.getKeyTime()).append("&").append(CosXmlConst.Q_HEADER_LIST).append("=").append(xmlSourceSerializer.getRealHeaderList().toLowerCase()).append("&").append(CosXmlConst.Q_URL_PARAM_LIST).append("=").append(xmlSourceSerializer.getRealParameterList().toLowerCase()).append("&").append(CosXmlConst.Q_SIGNATURE).append("=").append(signature);
        QCloudLogger.debug(this.logger, "authorization is " + authorization.toString());
        return authorization.toString();
    }
}

