/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.object.OptionObjectResult;
import com.tencent.qcloud.network.QCloudRequest;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.exception.QCloudExceptionType;
import com.tencent.qcloud.network.response.serializer.body.ResponseXmlS3BodySerializer;
import com.tencent.qcloud.network.response.serializer.http.HttpPassAllSerializer;
import java.util.Map;

public class OptionObjectRequest
extends CosXmlRequest {
    private String origin;
    private String accessControlMethod;
    private String accessControlHeaders;
    private String cosPath;

    public OptionObjectRequest() {
        this.contentType = "application/x-www-form-urlencoded";
        this.requestHeaders.put("Content-Type", this.contentType);
    }

    @Override
    public void build() {
        this.priority = QCloudRequest.QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_NORMAL;
        this.setRequestMethod();
        this.requestOriginBuilder.method(this.requestMethod);
        this.setRequestPath();
        this.requestOriginBuilder.pathAddRear(this.requestPath);
        this.requestOriginBuilder.hostAddFront(this.bucket);
        this.setRequestQueryParams();
        if (this.requestQueryParams.size() > 0) {
            for (Map.Entry entry : this.requestQueryParams.entrySet()) {
                this.requestOriginBuilder.query((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.requestHeaders.size() > 0) {
            for (Map.Entry entry : this.requestHeaders.entrySet()) {
                this.requestOriginBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.responseSerializer = new HttpPassAllSerializer();
        this.responseBodySerializer = new ResponseXmlS3BodySerializer(OptionObjectResult.class);
    }

    @Override
    protected void setRequestQueryParams() {
    }

    @Override
    public void checkParameters() throws QCloudException {
        if (this.bucket == null) {
            throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "bucket must not be null");
        }
        if (this.cosPath == null) {
            throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "cosPath must not be null");
        }
    }

    @Override
    protected void setRequestMethod() {
        this.requestMethod = "OPTIONS";
    }

    @Override
    protected void setRequestPath() {
        if (this.cosPath != null) {
            this.requestPath = !this.cosPath.startsWith("/") ? "/" + this.cosPath : this.cosPath;
        }
    }

    public void setOrigin(String origin) {
        this.origin = origin;
        if (origin != null) {
            this.requestHeaders.put("Origin", origin);
        }
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setAccessControlMethod(String accessControlMethod) {
        this.accessControlMethod = accessControlMethod;
        if (accessControlMethod != null) {
            this.requestHeaders.put("Access-Control-Request-Method", accessControlMethod);
        }
    }

    public String getAccessControlMethod() {
        return this.accessControlMethod;
    }

    public void setAccessControlHeaders(String accessControlHeaders) {
        this.accessControlHeaders = accessControlHeaders;
        if (accessControlHeaders != null) {
            this.requestHeaders.put("Access-Control-Request-Headers", accessControlHeaders);
        }
    }

    public String getAccessControlHeaders() {
        return this.accessControlHeaders;
    }

    public void setCosPath(String cosPath) {
        this.cosPath = cosPath;
    }

    public String getCosPath() {
        return this.cosPath;
    }
}

