/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.common.COSACL;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.object.InitMultipartUploadResult;
import com.tencent.qcloud.network.QCloudRequest;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.exception.QCloudExceptionType;
import com.tencent.qcloud.network.request.serializer.body.RequestByteArraySerializer;
import com.tencent.qcloud.network.response.serializer.body.ResponseXmlS3BodySerializer;
import com.tencent.qcloud.network.response.serializer.http.HttpPassAllSerializer;
import java.util.List;
import java.util.Map;

public class InitMultipartUploadRequest
extends CosXmlRequest {
    private String cosPath;

    public InitMultipartUploadRequest() {
        this.contentType = "multipart/form-data";
    }

    @Override
    public void build() {
        this.priority = QCloudRequest.QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_NORMAL;
        this.setRequestMethod();
        this.requestOriginBuilder.method(this.requestMethod);
        this.setRequestPath();
        this.requestOriginBuilder.pathAddRear(this.requestPath);
        this.requestOriginBuilder.hostAddFront(this.bucket);
        this.setRequestQueryParams();
        if (this.requestQueryParams.size() > 0) {
            for (Map.Entry entry : this.requestQueryParams.entrySet()) {
                this.requestOriginBuilder.query((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.requestHeaders.size() > 0) {
            for (Map.Entry entry : this.requestHeaders.entrySet()) {
                this.requestOriginBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.requestBodySerializer = new RequestByteArraySerializer(new byte[0], "text/plain");
        this.responseSerializer = new HttpPassAllSerializer();
        this.responseBodySerializer = new ResponseXmlS3BodySerializer(InitMultipartUploadResult.class);
    }

    @Override
    protected void setRequestQueryParams() {
        this.requestQueryParams.put("uploads", null);
    }

    @Override
    public void checkParameters() throws QCloudException {
        if (this.bucket == null) {
            throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "bucket must not be null");
        }
        if (this.cosPath == null) {
            throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "cosPath must not be null");
        }
    }

    @Override
    protected void setRequestMethod() {
        this.requestMethod = "POST";
    }

    @Override
    protected void setRequestPath() {
        if (this.cosPath != null) {
            this.requestPath = !this.cosPath.startsWith("/") ? "/" + this.cosPath : this.cosPath;
        }
    }

    public void setCosPath(String cosPath) {
        this.cosPath = cosPath;
    }

    public String getCosPath() {
        return this.cosPath;
    }

    public void setCacheControl(String cacheControl) {
        if (cacheControl == null) {
            return;
        }
        this.requestHeaders.put("Cache-Control", cacheControl);
    }

    public void setContentDisposition(String contentDisposition) {
        if (contentDisposition == null) {
            return;
        }
        this.requestHeaders.put("Content-Disposition", contentDisposition);
    }

    public void setContentEncodeing(String contentEncodeing) {
        if (contentEncodeing == null) {
            return;
        }
        this.requestHeaders.put("Content-Encoding", contentEncodeing);
    }

    public void setExpires(String expires) {
        if (expires == null) {
            return;
        }
        this.requestHeaders.put("Expires", expires);
    }

    public void setXCOSMeta(String key, String value) {
        if (key != null && value != null) {
            this.requestHeaders.put(key, value);
        }
    }

    public void setXCOSACL(String xCOSACL) {
        if (xCOSACL != null) {
            this.requestHeaders.put("x-cos-acl", xCOSACL);
        }
    }

    public void setXCOSACL(COSACL xCOSACL) {
        if (xCOSACL != null) {
            this.requestHeaders.put("x-cos-acl", xCOSACL.getACL());
        }
    }

    public void setXCOSGrantReadWithUIN(List<String> uinList) {
        this.setXCOSGrant(uinList, 1, 0);
    }

    public void setXCOSGrantRead(List<String> idList) {
        this.setXCOSGrant(idList, 0, 0);
    }

    public void setXCOSGrantWriteWithUIN(List<String> uinList) {
        this.setXCOSGrant(uinList, 1, 1);
    }

    public void setXCOSGrantWrite(List<String> idList) {
        this.setXCOSGrant(idList, 0, 1);
    }

    public void setXCOSReadWriteWithUIN(List<String> uinList) {
        this.setXCOSGrant(uinList, 1, 2);
    }

    public void setXCOSReadWrite(List<String> idList) {
        this.setXCOSGrant(idList, 0, 2);
    }

    private String getXCOSGrantForId(List<String> idList) {
        if (idList != null) {
            int size = idList.size();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < size - 1; ++i) {
                stringBuilder.append("id=\"qcs::cam::").append(idList.get(i)).append("\"").append(",");
            }
            stringBuilder.append("id=\"qcs::cam::").append(idList.get(size - 1)).append("\"");
            return stringBuilder.toString();
        }
        return null;
    }

    private String getXCOSGrantForUIN(List<String> uinList) {
        if (uinList != null) {
            int size = uinList.size();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < size - 1; ++i) {
                stringBuilder.append("uin=").append("\"").append(uinList.get(i)).append("\"").append(",");
            }
            stringBuilder.append("uin=").append("\"").append(uinList.get(size - 1)).append("\"");
            return stringBuilder.toString();
        }
        return null;
    }

    private void setXCOSGrant(List<String> list, int idType, int grantType) {
        if (list != null) {
            String grantMsg = null;
            if (idType == 0) {
                grantMsg = this.getXCOSGrantForUIN(list);
            } else if (idType == 1) {
                grantMsg = this.getXCOSGrantForId(list);
            }
            switch (grantType) {
                case 0: {
                    this.requestHeaders.put("x-cos-grant-read", grantMsg);
                    break;
                }
                case 1: {
                    this.requestHeaders.put("x-cos-grant-write", grantMsg);
                    break;
                }
                case 2: {
                    this.requestHeaders.put("x-cos-grant-full-control", grantMsg);
                }
            }
        }
    }
}

