/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.object.DeleteMultiObjectResult;
import com.tencent.cos.xml.model.tag.Delete;
import com.tencent.cos.xml.model.tag.DeleteObject;
import com.tencent.qcloud.network.QCloudRequest;
import com.tencent.qcloud.network.action.QCloudBodyMd5Action;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.exception.QCloudExceptionType;
import com.tencent.qcloud.network.request.serializer.body.RequestXmlBodySerializer;
import com.tencent.qcloud.network.response.serializer.body.ResponseXmlS3BodySerializer;
import com.tencent.qcloud.network.response.serializer.http.HttpPassAllSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DeleteMultiObjectRequest
extends CosXmlRequest {
    private Delete delete = new Delete();

    public DeleteMultiObjectRequest() {
        this.contentType = "application/xml";
        this.requestHeaders.put("Content-Type", this.contentType);
        this.delete.deleteObjectList = new ArrayList<DeleteObject>();
    }

    @Override
    public void build() {
        this.priority = QCloudRequest.QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_NORMAL;
        this.setRequestMethod();
        this.requestOriginBuilder.method(this.requestMethod);
        this.setRequestPath();
        this.requestOriginBuilder.pathAddRear(this.requestPath);
        this.requestOriginBuilder.hostAddFront(this.bucket);
        this.setRequestQueryParams();
        if (this.requestQueryParams.size() > 0) {
            for (Map.Entry entry : this.requestQueryParams.entrySet()) {
                this.requestOriginBuilder.query((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.requestHeaders.size() > 0) {
            for (Map.Entry entry : this.requestHeaders.entrySet()) {
                this.requestOriginBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.requestBodySerializer = new RequestXmlBodySerializer(this.delete);
        this.requestActions.add(new QCloudBodyMd5Action(this));
        this.responseSerializer = new HttpPassAllSerializer();
        this.responseBodySerializer = new ResponseXmlS3BodySerializer(DeleteMultiObjectResult.class);
    }

    @Override
    protected void setRequestQueryParams() {
        this.requestQueryParams.put("delete", null);
    }

    @Override
    public void checkParameters() throws QCloudException {
        if (this.bucket == null) {
            throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "bucket must not be null");
        }
    }

    @Override
    protected void setRequestMethod() {
        this.requestMethod = "POST";
    }

    @Override
    protected void setRequestPath() {
        this.requestPath = "/";
    }

    public void setQuiet(boolean quiet) {
        this.delete.quiet = quiet;
    }

    public void setObjectList(String object) {
        if (object != null) {
            if (object.startsWith("/")) {
                object = object.substring(1);
            }
            DeleteObject deleteObject = new DeleteObject();
            deleteObject.key = object;
            this.delete.deleteObjectList.add(deleteObject);
        }
    }

    public void setObjectList(List<String> objectList) {
        if (objectList != null) {
            int size = objectList.size();
            for (int i = 0; i < size; ++i) {
                DeleteObject deleteObject = new DeleteObject();
                String object = objectList.get(i);
                deleteObject.key = object.startsWith("/") ? object.substring(1) : object;
                this.delete.deleteObjectList.add(deleteObject);
            }
        }
    }

    public Delete getDelete() {
        return this.delete;
    }
}

