/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.bucket;

import com.tencent.cos.xml.common.COSACL;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.bucket.PutBucketResult;
import com.tencent.qcloud.network.QCloudRequest;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.exception.QCloudExceptionType;
import com.tencent.qcloud.network.request.serializer.body.RequestByteArraySerializer;
import com.tencent.qcloud.network.response.serializer.body.ResponseXmlS3BodySerializer;
import com.tencent.qcloud.network.response.serializer.http.HttpPassAllSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PutBucketRequest
extends CosXmlRequest {
    private String xCOSACL;
    private List<String> xCosGrantRead;
    private List<String> xCosGrantWrite;
    private List<String> xCosGrantFullControl;

    public PutBucketRequest() {
        this.contentType = "application/x-www-form-urlencoded";
        this.requestHeaders.put("Content-Type", this.contentType);
        this.xCosGrantFullControl = new ArrayList<String>();
        this.xCosGrantRead = new ArrayList<String>();
        this.xCosGrantWrite = new ArrayList<String>();
    }

    @Override
    public void build() {
        this.priority = QCloudRequest.QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_NORMAL;
        this.setRequestMethod();
        this.requestOriginBuilder.method(this.requestMethod);
        this.setRequestPath();
        this.requestOriginBuilder.pathAddRear(this.requestPath);
        this.requestOriginBuilder.hostAddFront(this.bucket);
        this.setRequestQueryParams();
        if (this.requestQueryParams.size() > 0) {
            for (Map.Entry entry : this.requestQueryParams.entrySet()) {
                this.requestOriginBuilder.query((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.setACLHeaders();
        if (this.requestHeaders.size() > 0) {
            for (Map.Entry entry : this.requestHeaders.entrySet()) {
                this.requestOriginBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.requestBodySerializer = new RequestByteArraySerializer(new byte[0], "text/plain");
        this.responseSerializer = new HttpPassAllSerializer();
        this.responseBodySerializer = new ResponseXmlS3BodySerializer(PutBucketResult.class);
    }

    @Override
    protected void setRequestQueryParams() {
    }

    @Override
    public void checkParameters() throws QCloudException {
        if (this.bucket == null) {
            throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "bucket must not be null");
        }
    }

    @Override
    protected void setRequestMethod() {
        this.requestMethod = "PUT";
    }

    @Override
    protected void setRequestPath() {
        this.requestPath = "/";
    }

    public void setXCOSACL(COSACL cosacl) {
        this.xCOSACL = cosacl.getACL();
    }

    public String getXCOSACL() {
        return this.xCOSACL;
    }

    public void setxCosGrantRead(String rootAccountID, List<String> subAccountID) {
        if (rootAccountID != null) {
            if (subAccountID != null) {
                int size = subAccountID.size();
                for (int i = 0; i < size; ++i) {
                    String uin = "uin = \"" + rootAccountID + "/" + subAccountID.get(i) + "\"";
                    this.xCosGrantRead.add(uin);
                }
            } else {
                String uin = "uin = \"" + rootAccountID + "\"";
                this.xCosGrantRead.add(uin);
            }
        }
    }

    public List<String> getxCosGrantRead() {
        return this.xCosGrantRead;
    }

    public void setxCosGrantWrite(String rootAccountID, List<String> subAccountID) {
        if (rootAccountID != null) {
            if (subAccountID != null) {
                int size = subAccountID.size();
                for (int i = 0; i < size; ++i) {
                    String uin = "uin = \"" + rootAccountID + "/" + subAccountID.get(i) + "\"";
                    this.xCosGrantWrite.add(uin);
                }
            } else {
                String uin = "uin = \"" + rootAccountID + "\"";
                this.xCosGrantWrite.add(uin);
            }
        }
    }

    public List<String> getxCosGrantWrite() {
        return this.xCosGrantWrite;
    }

    public void setxCosGrantFullControl(String rootAccountID, List<String> subAccountID) {
        if (rootAccountID != null) {
            if (subAccountID != null) {
                int size = subAccountID.size();
                for (int i = 0; i < size; ++i) {
                    String uin = "uin = \"" + rootAccountID + "/" + subAccountID.get(i) + "\"";
                    this.xCosGrantFullControl.add(uin);
                }
            } else {
                String uin = "uin = \"" + rootAccountID + "\"";
                this.xCosGrantFullControl.add(uin);
            }
        }
    }

    public List<String> getxCosGrantFullControl() {
        return this.xCosGrantFullControl;
    }

    private void setACLHeaders() {
        int i;
        int size;
        StringBuilder stringBuilder;
        if (this.xCOSACL != null) {
            this.requestHeaders.put("x-cos-acl", this.xCOSACL);
        }
        if (this.xCosGrantRead.size() > 0) {
            stringBuilder = new StringBuilder();
            size = this.xCosGrantRead.size();
            for (i = 0; i < size - 1; ++i) {
                stringBuilder.append(this.xCosGrantRead.get(i)).append(",");
            }
            stringBuilder.append(this.xCosGrantRead.get(size - 1));
            this.requestHeaders.put("x-cos-grant-read", stringBuilder.toString());
        }
        if (this.xCosGrantWrite.size() > 0) {
            stringBuilder = new StringBuilder();
            size = this.xCosGrantWrite.size();
            for (i = 0; i < size - 1; ++i) {
                stringBuilder.append(this.xCosGrantWrite.get(i)).append(",");
            }
            stringBuilder.append(this.xCosGrantWrite.get(size - 1));
            this.requestHeaders.put("x-cos-grant-write", stringBuilder.toString());
        }
        if (this.xCosGrantFullControl.size() > 0) {
            stringBuilder = new StringBuilder();
            size = this.xCosGrantFullControl.size();
            for (i = 0; i < size - 1; ++i) {
                stringBuilder.append(this.xCosGrantFullControl.get(i)).append(",");
            }
            stringBuilder.append(this.xCosGrantFullControl.get(size - 1));
            this.requestHeaders.put("x-cos-grant-full-control", stringBuilder.toString());
        }
    }
}

