/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.bucket;

import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.bucket.PutBucketCORSResult;
import com.tencent.cos.xml.model.tag.CORSConfiguration;
import com.tencent.cos.xml.model.tag.CORSRule;
import com.tencent.qcloud.network.QCloudRequest;
import com.tencent.qcloud.network.action.QCloudBodyMd5Action;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.exception.QCloudExceptionType;
import com.tencent.qcloud.network.request.serializer.body.RequestXmlBodySerializer;
import com.tencent.qcloud.network.response.serializer.body.ResponseXmlS3BodySerializer;
import com.tencent.qcloud.network.response.serializer.http.HttpPassAllSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PutBucketCORSRequest
extends CosXmlRequest {
    private CORSConfiguration corsConfiguration;

    public PutBucketCORSRequest() {
        this.contentType = "application/xml";
        this.requestHeaders.put("Content-Type", this.contentType);
        this.corsConfiguration = new CORSConfiguration();
        this.corsConfiguration.corsRules = new ArrayList<CORSRule>();
    }

    @Override
    public void build() {
        this.priority = QCloudRequest.QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_NORMAL;
        this.setRequestMethod();
        this.requestOriginBuilder.method(this.requestMethod);
        this.setRequestPath();
        this.requestOriginBuilder.pathAddRear(this.requestPath);
        this.requestOriginBuilder.hostAddFront(this.bucket);
        this.setRequestQueryParams();
        if (this.requestQueryParams.size() > 0) {
            for (Map.Entry entry : this.requestQueryParams.entrySet()) {
                this.requestOriginBuilder.query((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.requestHeaders.size() > 0) {
            for (Map.Entry entry : this.requestHeaders.entrySet()) {
                this.requestOriginBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.requestActions.add(new QCloudBodyMd5Action(this));
        this.requestBodySerializer = new RequestXmlBodySerializer(this.corsConfiguration);
        this.responseSerializer = new HttpPassAllSerializer();
        this.responseBodySerializer = new ResponseXmlS3BodySerializer(PutBucketCORSResult.class);
    }

    @Override
    protected void setRequestQueryParams() {
        this.requestQueryParams.put("cors", null);
    }

    @Override
    public void checkParameters() throws QCloudException {
        if (this.bucket == null) {
            throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "bucket must not be null");
        }
    }

    @Override
    protected void setRequestMethod() {
        this.requestMethod = "PUT";
    }

    @Override
    protected void setRequestPath() {
        this.requestPath = "/";
    }

    public void setCORSRuleList(List<CORSRule> corsRuleList) {
        if (corsRuleList != null) {
            this.corsConfiguration.corsRules.addAll(corsRuleList);
        }
    }

    public void setCORSRuleList(CORSRule corsRule) {
        if (corsRule != null) {
            this.corsConfiguration.corsRules.add(corsRule);
        }
    }

    public CORSConfiguration getCorsConfiguration() {
        return this.corsConfiguration;
    }
}

