/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.bucket;

import android.text.TextUtils;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.bucket.ListMultiUploadsResult;
import com.tencent.qcloud.network.QCloudRequest;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.exception.QCloudExceptionType;
import com.tencent.qcloud.network.response.serializer.body.ResponseXmlS3BodySerializer;
import com.tencent.qcloud.network.response.serializer.http.HttpPassAllSerializer;
import java.util.Map;

public class ListMultiUploadsRequest
extends CosXmlRequest {
    private String delimiter;
    private String encodingType;
    private String prefix;
    private String maxUploads;
    private String keyMarker;
    private String uploadIdMarker;

    public ListMultiUploadsRequest() {
        this.contentType = "application/x-www-form-urlencoded";
        this.requestHeaders.put("Content-Type", this.contentType);
    }

    @Override
    public void build() {
        this.priority = QCloudRequest.QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_NORMAL;
        this.setRequestMethod();
        this.requestOriginBuilder.method(this.requestMethod);
        this.setRequestPath();
        this.requestOriginBuilder.pathAddRear(this.requestPath);
        this.requestOriginBuilder.hostAddFront(this.bucket);
        this.setRequestQueryParams();
        if (this.requestQueryParams.size() > 0) {
            for (Map.Entry entry : this.requestQueryParams.entrySet()) {
                this.requestOriginBuilder.query((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.requestHeaders.size() > 0) {
            for (Map.Entry entry : this.requestHeaders.entrySet()) {
                this.requestOriginBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.responseSerializer = new HttpPassAllSerializer();
        this.responseBodySerializer = new ResponseXmlS3BodySerializer(ListMultiUploadsResult.class);
    }

    @Override
    protected void setRequestQueryParams() {
        this.requestQueryParams.put("uploads", null);
        if (!TextUtils.isEmpty((CharSequence)this.delimiter)) {
            this.requestQueryParams.put("delimiter", this.delimiter);
        }
        if (!TextUtils.isEmpty((CharSequence)this.encodingType)) {
            this.requestQueryParams.put("Encoding-type", this.encodingType);
        }
        if (!TextUtils.isEmpty((CharSequence)this.prefix)) {
            this.requestQueryParams.put("Prefix", this.prefix);
        }
        if (!TextUtils.isEmpty((CharSequence)this.maxUploads)) {
            this.requestQueryParams.put("max-uploads", this.maxUploads);
        }
        if (!TextUtils.isEmpty((CharSequence)this.keyMarker)) {
            this.requestQueryParams.put("key-marker", this.keyMarker);
        }
        if (!TextUtils.isEmpty((CharSequence)this.uploadIdMarker)) {
            this.requestQueryParams.put("upload-id-marker", this.uploadIdMarker);
        }
    }

    @Override
    public void checkParameters() throws QCloudException {
        if (this.bucket == null) {
            throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "bucket must not be null");
        }
    }

    @Override
    protected void setRequestMethod() {
        this.requestMethod = "GET";
    }

    @Override
    protected void setRequestPath() {
        this.requestPath = "/";
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public void setKeyMarker(String keyMarker) {
        this.keyMarker = keyMarker;
    }

    public String getKeyMarker() {
        return this.keyMarker;
    }

    public void setMaxUploads(String maxUploads) {
        this.maxUploads = maxUploads;
    }

    public String getMaxUploads() {
        return this.maxUploads;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setUploadIdMarker(String uploadIdMarker) {
        this.uploadIdMarker = uploadIdMarker;
    }

    public String getUploadIdMarker() {
        return this.uploadIdMarker;
    }
}

