/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model;

import com.tencent.cos.xml.sign.CosXmlSignatureSourceSerializer;
import com.tencent.qcloud.network.QCloudHttpRequest;
import com.tencent.qcloud.network.exception.QCloudException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class CosXmlRequest
extends QCloudHttpRequest {
    protected String requestMethod = "GET";
    protected String requestPath;
    protected Map<String, String> requestQueryParams = new LinkedHashMap<String, String>();
    protected String requestFragment;
    protected Map<String, String> requestHeaders = new LinkedHashMap<String, String>();
    protected Map<String, String> requestBodyParams = new LinkedHashMap<String, String>();
    protected String contentType = "application/xml";
    protected String expect;
    protected String xCOSContentSha1;
    protected String bucket;
    CosXmlSignatureSourceSerializer cosXmlSignatureSourceSerializer;

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setSign(long signDuration, Set<String> checkHeaderListForSign, Set<String> checkParameterListForSing) {
        if (signDuration < 0L) {
            signDuration = 600L;
        }
        this.cosXmlSignatureSourceSerializer = new CosXmlSignatureSourceSerializer(signDuration);
        if (checkHeaderListForSign != null) {
            this.cosXmlSignatureSourceSerializer.headers(checkHeaderListForSign);
        }
        if (checkParameterListForSing != null) {
            this.cosXmlSignatureSourceSerializer.parameters(checkParameterListForSing);
        }
        this.setSourceSerializer(this.cosXmlSignatureSourceSerializer);
    }

    public void setExpect(String expect) {
        if (expect == null) {
            return;
        }
        this.expect = expect;
        this.requestHeaders.put("Expect", expect);
    }

    public String getExpect() {
        return this.expect;
    }

    public void setXCOSContentSha1(String xCOSContentSha1) {
        if (xCOSContentSha1 == null) {
            return;
        }
        this.xCOSContentSha1 = xCOSContentSha1;
        this.requestHeaders.put("x-cos-content-sha1", xCOSContentSha1);
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public Map<String, String> getRequestQueryParams() {
        return this.requestQueryParams;
    }

    public Map<String, String> getRequestBodyParams() {
        return this.requestBodyParams;
    }

    public String getXCOSContentSha1() {
        return this.xCOSContentSha1;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    protected abstract void setRequestMethod();

    protected abstract void setRequestPath();

    protected abstract void setRequestQueryParams();

    public abstract void checkParameters() throws QCloudException;
}

