/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rmonitor.base.reporter;

import android.content.Context;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.IntRange;
import android.support.annotation.RestrictTo;
import android.text.TextUtils;
import com.tencent.bugly.common.network.NetworkWatcher;
import com.tencent.bugly.common.reporter.IReporter;
import com.tencent.bugly.common.reporter.data.ReportData;
import com.tencent.bugly.common.reporter.data.ReportStrategy;
import com.tencent.bugly.common.reporter.upload.UploadProxy;
import com.tencent.bugly.common.thread.ThreadManager;
import com.tencent.bugly.proguard.bq;
import com.tencent.bugly.proguard.by;
import com.tencent.bugly.proguard.iu;
import com.tencent.bugly.proguard.ph;
import com.tencent.rmonitor.base.db.DBDataStatus;
import com.tencent.rmonitor.base.meta.BaseInfo;
import com.tencent.rmonitor.base.plugin.monitor.PluginController;
import com.tencent.rmonitor.base.reporter.DiscardReason;
import com.tencent.rmonitor.base.reporter.IReportCache;
import com.tencent.rmonitor.base.reporter.ReporterMachine;
import com.tencent.rmonitor.base.reporter.ReporterMachine$WhenMappings;
import com.tencent.rmonitor.base.reporter.batch.ReportCacheImpl;
import com.tencent.rmonitor.common.logger.Logger;
import com.tencent.rmonitor.common.util.JsonUtil;
import com.tencent.rmonitor.sla.AttaEvent;
import com.tencent.rmonitor.sla.AttaEventReporter;
import com.tencent.rmonitor.sla.StatisticsReporter;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001HB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020)H\u0002J\n\u0010*\u001a\u0004\u0018\u00010\u0001H\u0002J\u001a\u0010+\u001a\u00020\u001b2\b\b\u0002\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\"\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020-2\u0006\u0010(\u001a\u00020)2\b\u00102\u001a\u0004\u0018\u000103H\u0002J\u0006\u00104\u001a\u00020\fJ\u000e\u00105\u001a\u0002062\u0006\u0010.\u001a\u00020/J\u0016\u00107\u001a\u0002062\u0006\u0010.\u001a\u00020/2\u0006\u00108\u001a\u000209J\u0018\u0010:\u001a\u0002062\u0006\u0010(\u001a\u00020)2\u0006\u0010;\u001a\u00020<H\u0002J0\u0010=\u001a\u0002062\u0006\u0010(\u001a\u00020)2\u0006\u0010>\u001a\u00020\f2\u0006\u00101\u001a\u00020-2\u0006\u0010?\u001a\u00020-2\u0006\u0010@\u001a\u000209H\u0002J6\u0010A\u001a\u0002062\u0006\u0010(\u001a\u00020)2\u0006\u0010>\u001a\u00020\f2\u0006\u0010B\u001a\u00020\f2\u0006\u00101\u001a\u00020-2\u0006\u0010?\u001a\u00020-2\u0006\u0010@\u001a\u000209J(\u0010C\u001a\u0002062\u0006\u0010(\u001a\u00020)2\u0006\u00101\u001a\u00020-2\u0006\u0010?\u001a\u00020-2\u0006\u0010@\u001a\u000209H\u0002J\u001a\u0010D\u001a\u0002062\u0006\u0010(\u001a\u00020)2\b\u00102\u001a\u0004\u0018\u000103H\u0002J\u001a\u0010E\u001a\u00020\f2\u0006\u0010(\u001a\u00020)2\b\u00102\u001a\u0004\u0018\u000103H\u0016J\u0006\u0010F\u001a\u000206J\u0010\u0010G\u001a\u00020\f2\u0006\u0010(\u001a\u00020)H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\"\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006I"}, d2={"Lcom/tencent/rmonitor/base/reporter/ReporterMachine;", "Lcom/tencent/bugly/common/reporter/IReporter;", "()V", "TAG", "", "handler", "Landroid/os/Handler;", "getHandler", "()Landroid/os/Handler;", "setHandler", "(Landroid/os/Handler;)V", "isStarted", "", "reportCache", "Lcom/tencent/rmonitor/base/reporter/IReportCache;", "getReportCache", "()Lcom/tencent/rmonitor/base/reporter/IReportCache;", "setReportCache", "(Lcom/tencent/rmonitor/base/reporter/IReportCache;)V", "reportListener", "Lcom/tencent/rmonitor/base/reporter/IReportListener;", "getReportListener", "()Lcom/tencent/rmonitor/base/reporter/IReportListener;", "setReportListener", "(Lcom/tencent/rmonitor/base/reporter/IReportListener;)V", "reportQueue", "Ljava/util/concurrent/PriorityBlockingQueue;", "Lcom/tencent/rmonitor/base/reporter/ReporterMachine$ReportTask;", "getReportQueue", "()Ljava/util/concurrent/PriorityBlockingQueue;", "setReportQueue", "(Ljava/util/concurrent/PriorityBlockingQueue;)V", "reportThread", "Ljava/lang/Thread;", "uploadProxy", "getUploadProxy", "()Lcom/tencent/bugly/common/reporter/IReporter;", "setUploadProxy", "(Lcom/tencent/bugly/common/reporter/IReporter;)V", "checkNetStrategy", "reportData", "Lcom/tencent/bugly/common/reporter/data/ReportData;", "getReporter", "getRunnableTask", "priority", "", "runnable", "Ljava/lang/Runnable;", "handleRetryStrategy", "errorCode", "callback", "Lcom/tencent/bugly/common/reporter/IReporter$ReportCallback;", "isStart", "post", "", "postDelayed", "delay", "", "recordDiscard", "discardReason", "Lcom/tencent/rmonitor/base/reporter/DiscardReason;", "recordUpload", "isSuccess", "contentLength", "costInMs", "recordUploadResult", "hasRetry", "reportErrorCode", "reportInternal", "reportNow", "start", "whetherBlock", "ReportTask", "bugly-pro_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ReporterMachine
implements IReporter {
    private static final String TAG = "RMonitor_report";
    private static volatile boolean isStarted;
    @NotNull
    private static Handler handler;
    @Nullable
    private static IReporter uploadProxy;
    @NotNull
    private static IReportCache reportCache;
    @Nullable
    private static iu reportListener;
    @NotNull
    private static PriorityBlockingQueue<ReportTask> reportQueue;
    private static final Thread reportThread;
    public static final ReporterMachine INSTANCE;

    @NotNull
    public final Handler getHandler() {
        return handler;
    }

    public final void setHandler(@NotNull Handler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"<set-?>");
        ReporterMachine.handler = handler;
    }

    @Nullable
    public final IReporter getUploadProxy() {
        return uploadProxy;
    }

    public final void setUploadProxy(@Nullable IReporter iReporter) {
        uploadProxy = iReporter;
    }

    @NotNull
    public final IReportCache getReportCache() {
        return reportCache;
    }

    public final void setReportCache(@NotNull IReportCache iReportCache) {
        Intrinsics.checkParameterIsNotNull((Object)iReportCache, (String)"<set-?>");
        reportCache = iReportCache;
    }

    @Nullable
    public final iu getReportListener() {
        return reportListener;
    }

    public final void setReportListener(@Nullable iu iu2) {
        reportListener = iu2;
    }

    @NotNull
    public final PriorityBlockingQueue<ReportTask> getReportQueue() {
        return reportQueue;
    }

    public final void setReportQueue(@NotNull PriorityBlockingQueue<ReportTask> priorityBlockingQueue) {
        Intrinsics.checkParameterIsNotNull(priorityBlockingQueue, (String)"<set-?>");
        reportQueue = priorityBlockingQueue;
    }

    @Override
    public final boolean reportNow(@NotNull ReportData reportData, @Nullable IReporter.ReportCallback reportCallback) {
        block8: {
            block7: {
                Intrinsics.checkParameterIsNotNull((Object)reportData, (String)"reportData");
                if (Logger.verbos) {
                    Logger.INSTANCE.v(TAG, "reportNow, dbId: " + reportData.getDbId() + ", eventName: " + reportData.getEventName() + " , reportStrategy:" + reportData.getReportStrategy());
                }
                if (reportData.getReportStrategy().getUploadStrategy() != ReportStrategy.UploadStrategy.UPLOAD_ANY) {
                    if (ReportStrategy.Companion.x(reportData.getPluginName())) {
                        reportData.getReportStrategy().setUploadStrategy(ReportStrategy.UploadStrategy.UPLOAD_ANY);
                        if (Logger.verbos) {
                            Logger.INSTANCE.v(TAG, "reportNow, adjust " + reportData.getEventName() + "'s uploadStrategy to UPLOAD_ANY");
                        }
                    }
                }
                if (this.whetherBlock(reportData)) {
                    IReporter.ReportCallback reportCallback2 = reportCallback;
                    if (reportCallback2 != null) {
                        reportCallback2.onSuccess(reportData.getDbId(), 0);
                    }
                    return true;
                }
                if (reportData.getShouldRecordLinkData()) {
                    by.au().j(reportData.getParams());
                    reportData.setShouldRecordLinkData(false);
                }
                if (!this.checkNetStrategy(reportData)) break block7;
                reportQueue.offer(new ReportTask(reportData.getReportStrategy().getPriority(), reportData, reportCallback));
                break block8;
            }
            reportQueue.offer(this.getRunnableTask(2, new Runnable(reportData){
                final /* synthetic */ ReportData $reportData;

                public final void run() {
                    ReporterMachine.INSTANCE.getReportCache().cacheReportDataSync(this.$reportData);
                }
                {
                    this.$reportData = reportData;
                }
            }));
            IReporter.ReportCallback reportCallback3 = reportCallback;
            if (reportCallback3 == null) break block8;
            reportCallback3.onCached();
        }
        return true;
    }

    public final void post(@NotNull Runnable runnable2) {
        Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"runnable");
        if (Logger.verbos) {
            Logger.INSTANCE.v(TAG, "post");
        }
        reportQueue.offer(this.getRunnableTask(2, runnable2));
    }

    public final void postDelayed(@NotNull Runnable runnable2, long l2) {
        Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"runnable");
        if (Logger.verbos) {
            Logger.INSTANCE.v(TAG, "postDelay, delay:".concat(String.valueOf(l2)));
        }
        handler.postDelayed(new Runnable(runnable2){
            final /* synthetic */ Runnable $runnable;

            public final void run() {
                ReporterMachine.INSTANCE.getReportQueue().offer(ReporterMachine.access$getRunnableTask(ReporterMachine.INSTANCE, 2, this.$runnable));
            }
            {
                this.$runnable = runnable2;
            }
        }, l2);
    }

    private final boolean whetherBlock(ReportData reportData) {
        String string = reportData.getPluginName();
        if (!PluginController.INSTANCE.whetherPluginSampling(string)) {
            Logger.INSTANCE.d(TAG, "block report for not hit sampling, plugin: " + string + " .");
            return true;
        }
        if (reportData.getDbId() <= 0 && !PluginController.INSTANCE.canCollect(string)) {
            Logger.INSTANCE.d(TAG, "block report for exceed limit, plugin: " + string + " .");
            return true;
        }
        return false;
    }

    private final ReportTask getRunnableTask(int n2, Runnable runnable2) {
        ReportTask reportTask2 = new ReportTask(n2, null, null);
        reportTask2.setRunnable(runnable2);
        return reportTask2;
    }

    static /* synthetic */ ReportTask getRunnableTask$default(ReporterMachine reporterMachine, int n2, Runnable runnable2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = 2;
        }
        return reporterMachine.getRunnableTask(n2, runnable2);
    }

    private final IReporter getReporter() {
        if (TextUtils.isEmpty((CharSequence)BaseInfo.userMeta.appId)) {
            Logger.INSTANCE.e(TAG, "appid is empty.");
        }
        if (BaseInfo.app == null) {
            Logger.INSTANCE.e(TAG, "app is null.");
        }
        if (uploadProxy == null && !TextUtils.isEmpty((CharSequence)BaseInfo.userMeta.appId)) {
            uploadProxy = new UploadProxy((Context)BaseInfo.app, BaseInfo.userMeta.appId);
        }
        if (uploadProxy == null) {
            Logger.INSTANCE.e(TAG, "IReporter is null.");
        }
        return uploadProxy;
    }

    private final void reportInternal(ReportData reportData, IReporter.ReportCallback reportCallback) {
        if (Logger.verbos) {
            Logger.INSTANCE.v(TAG, "reportInternal: " + reportData.getParams());
        }
        if (reportData.getReportStrategy().getNeedCache() && reportData.getDbId() <= 0) {
            reportCache.cacheReportDataSync(reportData);
        }
        if (Logger.verbos) {
            Logger.INSTANCE.v(TAG, "reportInternal, name: " + reportData.getPluginName() + ", dbID: " + reportData.getDbId() + ", cid: " + reportData.getParams().optString("client_identify"));
        }
        String string = reportData.getPluginName();
        long l2 = SystemClock.uptimeMillis();
        IReporter iReporter = this.getReporter();
        if (iReporter != null) {
            iReporter.reportNow(reportData, new IReporter.ReportCallback(l2, string, reportData, reportCallback){
                final /* synthetic */ long $startTime;
                final /* synthetic */ String $pluginName;
                final /* synthetic */ ReportData $reportData;
                final /* synthetic */ IReporter.ReportCallback $callback;

                public final void onSuccess(int n2, int n3) {
                    long l2 = SystemClock.uptimeMillis() - this.$startTime;
                    if (Logger.verbos) {
                        Logger.INSTANCE.v("RMonitor_report", "reportInternal-onSuccess, pluginName: " + this.$pluginName + ", dbId: " + n2);
                    }
                    ReporterMachine.INSTANCE.getReportCache().updateCacheDataStatus(n2, DBDataStatus.SENT);
                    ReporterMachine.INSTANCE.recordUploadResult(this.$reportData, true, true, 0, n3, l2);
                    IReporter.ReportCallback reportCallback = this.$callback;
                    if (reportCallback != null) {
                        reportCallback.onSuccess(n2, n3);
                        return;
                    }
                }

                public final void onFailure(int n2, @NotNull String string, int n3, int n4) {
                    Intrinsics.checkParameterIsNotNull((Object)string, (String)"errorMsg");
                    long l2 = SystemClock.uptimeMillis() - this.$startTime;
                    if (Logger.debug) {
                        Logger.INSTANCE.d("RMonitor_report", "reportInternal-onFailure, pluginName: " + this.$pluginName + ", dbId: " + n3 + ", errorCode: " + n2 + ", errorMsg: " + string);
                    }
                    ReporterMachine.INSTANCE.getReportCache().updateCacheDataStatus(n3, DBDataStatus.SENT_FAIL);
                    if (ReporterMachine.access$handleRetryStrategy(ReporterMachine.INSTANCE, n2, this.$reportData, this.$callback)) {
                        ReporterMachine.INSTANCE.recordUploadResult(this.$reportData, false, true, n2, n4, l2);
                        return;
                    }
                    ReporterMachine.INSTANCE.recordUploadResult(this.$reportData, false, false, n2, n4, l2);
                    IReporter.ReportCallback reportCallback = this.$callback;
                    if (reportCallback != null) {
                        reportCallback.onFailure(n2, string, n3, n4);
                        return;
                    }
                }
                {
                    this.$startTime = l2;
                    this.$pluginName = string;
                    this.$reportData = reportData;
                    this.$callback = reportCallback;
                }

                public final void onCached() {
                    IReporter.ReportCallback.DefaultImpls.ap();
                }
            });
        }
        if (reportListener != null) {
            bq.d(reportData.getParams());
        }
    }

    public final void start() {
        if (isStarted) {
            return;
        }
        Logger.INSTANCE.i(TAG, "start");
        ReporterMachine reporterMachine = this;
        synchronized (reporterMachine) {
            if (!isStarted) {
                reportCache.reportCacheData();
                reportThread.start();
                isStarted = true;
            }
            return;
        }
    }

    public final boolean isStart() {
        return isStarted;
    }

    private final boolean checkNetStrategy(ReportData reportData) {
        if (reportData.getReportStrategy().getUploadStrategy() == ReportStrategy.UploadStrategy.UPLOAD_ANY) {
            return true;
        }
        if (reportData.getReportStrategy().getUploadStrategy() == ReportStrategy.UploadStrategy.UPLOAD_WIFI && NetworkWatcher.INSTANCE.isWiFiConnectedRealtime()) {
            return true;
        }
        reportData.getReportStrategy().getUploadStrategy();
        return false;
    }

    private final boolean handleRetryStrategy(int n2, ReportData reportData, IReporter.ReportCallback reportCallback) {
        ReportStrategy reportStrategy = reportData.getReportStrategy();
        if (n2 == 600 || n2 == 700) {
            Logger.INSTANCE.d(TAG, "oom or other error happen, do not retry");
            ReportStrategy reportStrategy2 = reportStrategy;
            reportStrategy2.setAlreadyRetryTimes(reportStrategy2.getRetryTimes());
        }
        n2 = reportStrategy.getRetryTimes() - reportStrategy.getAlreadyRetryTimes();
        Logger.INSTANCE.d(TAG, "can retry " + n2 + " times");
        if (n2 <= 0) {
            Logger.INSTANCE.d(TAG, "no chance to retry");
            return false;
        }
        ReportStrategy reportStrategy3 = reportStrategy;
        reportStrategy3.setAlreadyRetryTimes(reportStrategy3.getAlreadyRetryTimes() + 1);
        switch (ReporterMachine$WhenMappings.$EnumSwitchMapping$0[reportStrategy.getRetryStrategy().ordinal()]) {
            case 1: {
                Logger.INSTANCE.d(TAG, "retry immediately");
                reportQueue.offer(new ReportTask(reportData.getReportStrategy().getPriority(), reportData, reportCallback));
                break;
            }
            case 2: {
                n2 = reportStrategy.getAlreadyRetryTimes() - 1;
                long l2 = (long)(Math.pow(2.0, n2) * 60000.0);
                Logger.INSTANCE.d(TAG, "retry " + l2 + "ms later");
                handler.postDelayed(new Runnable(reportData, reportCallback){
                    final /* synthetic */ ReportData $reportData;
                    final /* synthetic */ IReporter.ReportCallback $callback;

                    public final void run() {
                        ReporterMachine.INSTANCE.getReportQueue().offer(new ReportTask(this.$reportData.getReportStrategy().getPriority(), this.$reportData, this.$callback));
                    }
                    {
                        this.$reportData = reportData;
                        this.$callback = reportCallback;
                    }
                }, l2);
            }
        }
        return true;
    }

    public final void recordUploadResult(@NotNull ReportData reportData, boolean bl2, boolean bl3, int n2, int n3, long l2) {
        boolean bl4;
        Intrinsics.checkParameterIsNotNull((Object)reportData, (String)"reportData");
        boolean bl5 = bl4 = reportData.getDbId() > 0;
        if (bl2) {
            this.recordUpload(reportData, true, n2, n3, l2);
            return;
        }
        if (bl3) {
            this.recordUpload(reportData, false, n2, n3, l2);
            return;
        }
        if (bl4) {
            this.recordUpload(reportData, false, n2, n3, l2);
            return;
        }
        this.recordDiscard(reportData, DiscardReason.RETRY_EXCEEDED);
        this.recordUpload(reportData, false, n2, n3, l2);
    }

    private final void recordUpload(ReportData reportData, boolean bl2, int n2, int n3, long l2) {
        if (reportData.getReportType() == 1) {
            String string = JsonUtil.INSTANCE.safeGetJsonValue(reportData.getParams(), "base_type");
            String string2 = JsonUtil.INSTANCE.safeGetJsonValue(reportData.getParams(), "sub_type");
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return;
            }
            StatisticsReporter.Companion.getInstance().recordUpload(string, string2, bl2, n3, (int)l2);
            if (!bl2) {
                this.reportErrorCode(reportData, n2, n3, l2);
            }
        }
    }

    private final void recordDiscard(ReportData object, DiscardReason discardReason) {
        if (((ReportData)object).getReportType() == 1) {
            String string = JsonUtil.INSTANCE.safeGetJsonValue(((ReportData)object).getParams(), "base_type");
            object = JsonUtil.INSTANCE.safeGetJsonValue(((ReportData)object).getParams(), "sub_type");
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)((CharSequence)object))) {
                return;
            }
            StatisticsReporter.Companion.getInstance().recordDiscard(string, (String)object, discardReason);
        }
    }

    private final void reportErrorCode(ReportData reportData, int n2, int n3, long l2) {
        if (!ph.iJ().bp("RMReportErrorCode")) {
            Logger.INSTANCE.d(TAG, "reportErrorCode miss hit sampling, eventName: " + reportData.getEventName() + ", errorCode: " + n2);
            return;
        }
        AttaEvent attaEvent = new AttaEvent(null, 1, null);
        attaEvent.setEventCode("RMReportErrorCode");
        attaEvent.setEventResult(0);
        attaEvent.setErrorCode(n2);
        attaEvent.setEventCost((int)l2);
        attaEvent.setParam0(JsonUtil.INSTANCE.safeGetJsonValue(reportData.getParams(), "base_type"));
        attaEvent.setParam1(JsonUtil.INSTANCE.safeGetJsonValue(reportData.getParams(), "sub_type"));
        attaEvent.setParam2(String.valueOf(n3));
        attaEvent.setParam3(JsonUtil.INSTANCE.safeGetJsonValue(reportData.getParams(), "client_identify"));
        AttaEventReporter.Companion.getInstance().addEvent(attaEvent);
    }

    private ReporterMachine() {
    }

    static {
        INSTANCE = new ReporterMachine();
        handler = new Handler(ThreadManager.Companion.getMonitorThreadLooper());
        reportCache = new ReportCacheImpl();
        reportQueue = new PriorityBlockingQueue();
        reportThread = new Thread(reportThread.1.INSTANCE);
    }

    public static final /* synthetic */ ReportTask access$getRunnableTask(ReporterMachine reporterMachine, int n2, Runnable runnable2) {
        return reporterMachine.getRunnableTask(n2, runnable2);
    }

    public static final /* synthetic */ boolean access$handleRetryStrategy(ReporterMachine reporterMachine, int n2, ReportData reportData, IReporter.ReportCallback reportCallback) {
        return reporterMachine.handleRetryStrategy(n2, reportData, reportCallback);
    }

    public static final /* synthetic */ void access$reportInternal(ReporterMachine reporterMachine, ReportData reportData, IReporter.ReportCallback reportCallback) {
        reporterMachine.reportInternal(reportData, reportCallback);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001aB#\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0011\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0000H\u0096\u0002R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lcom/tencent/rmonitor/base/reporter/ReporterMachine$ReportTask;", "", "priority", "", "reportData", "Lcom/tencent/bugly/common/reporter/data/ReportData;", "callback", "Lcom/tencent/bugly/common/reporter/IReporter$ReportCallback;", "(ILcom/tencent/bugly/common/reporter/data/ReportData;Lcom/tencent/bugly/common/reporter/IReporter$ReportCallback;)V", "getCallback", "()Lcom/tencent/bugly/common/reporter/IReporter$ReportCallback;", "index", "getPriority", "()I", "getReportData", "()Lcom/tencent/bugly/common/reporter/data/ReportData;", "runnable", "Ljava/lang/Runnable;", "getRunnable", "()Ljava/lang/Runnable;", "setRunnable", "(Ljava/lang/Runnable;)V", "compareIndex", "otherIndex", "compareTo", "other", "Companion", "bugly-pro_release"})
    public static final class ReportTask
    implements Comparable<ReportTask> {
        private final int index;
        @Nullable
        private Runnable runnable;
        private final int priority;
        @Nullable
        private final ReportData reportData;
        @Nullable
        private final IReporter.ReportCallback callback;
        @NotNull
        private static AtomicInteger GLOBAL_INDEX;
        public static final Companion Companion;

        @Nullable
        public final Runnable getRunnable() {
            return this.runnable;
        }

        public final void setRunnable(@Nullable Runnable runnable2) {
            this.runnable = runnable2;
        }

        @Override
        public final int compareTo(@NotNull ReportTask reportTask2) {
            Intrinsics.checkParameterIsNotNull((Object)reportTask2, (String)"other");
            if (this.priority < reportTask2.priority) {
                return 1;
            }
            if (this.priority > reportTask2.priority) {
                return -1;
            }
            return this.compareIndex(reportTask2.index);
        }

        private final int compareIndex(int n2) {
            if (this.index > n2) {
                return 1;
            }
            if (this.priority < n2) {
                return -1;
            }
            return 0;
        }

        public final int getPriority() {
            return this.priority;
        }

        @Nullable
        public final ReportData getReportData() {
            return this.reportData;
        }

        @Nullable
        public final IReporter.ReportCallback getCallback() {
            return this.callback;
        }

        public ReportTask(@IntRange(from=0L, to=4L) int n2, @Nullable ReportData reportData, @Nullable IReporter.ReportCallback reportCallback) {
            this.priority = n2;
            this.reportData = reportData;
            this.callback = reportCallback;
            this.index = GLOBAL_INDEX.getAndIncrement();
        }

        static {
            Companion = new Companion(0);
            GLOBAL_INDEX = new AtomicInteger(0);
        }

        public static final /* synthetic */ AtomicInteger access$getGLOBAL_INDEX$cp() {
            return GLOBAL_INDEX;
        }

        public static final /* synthetic */ void access$setGLOBAL_INDEX$cp(AtomicInteger atomicInteger) {
            GLOBAL_INDEX = atomicInteger;
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/tencent/rmonitor/base/reporter/ReporterMachine$ReportTask$Companion;", "", "()V", "GLOBAL_INDEX", "Ljava/util/concurrent/atomic/AtomicInteger;", "getGLOBAL_INDEX", "()Ljava/util/concurrent/atomic/AtomicInteger;", "setGLOBAL_INDEX", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "bugly-pro_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(byte by2) {
                this();
            }
        }
    }
}

