/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.network;

import com.tencent.bugly.network.BuglyListenerFactory;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class BuglyCallbackProxy
implements Callback {
    private final Callback sX;

    public BuglyCallbackProxy(Callback callback) {
        this.sX = callback;
    }

    public void onFailure(Call call, IOException iOException) {
        try {
            if (this.sX != null) {
                this.sX.onFailure(call, iOException);
            }
        }
        catch (Throwable throwable) {}
        BuglyCallbackProxy.callFailed(call, iOException);
    }

    public void onResponse(Call call, Response response) {
        boolean bl2;
        IOException iOException = null;
        try {
            if (this.sX != null) {
                this.sX.onResponse(call, response);
            }
            bl2 = response != null && response.isSuccessful();
        }
        catch (IOException iOException2) {
            bl2 = false;
        }
        catch (Throwable throwable) {
            bl2 = false;
            iOException = new IOException(throwable.getMessage() + " " + response);
        }
        if (bl2) {
            BuglyListenerFactory.getInstance().onCallEnd(call, false, null);
            return;
        }
        if (iOException == null) {
            iOException = new IOException("Unexpected code: ".concat(String.valueOf(response)));
        }
        BuglyCallbackProxy.callFailed(call, iOException);
    }

    private static void callFailed(Call call, IOException iOException) {
        BuglyListenerFactory.getInstance().onCallEnd(call, true, iOException);
    }
}

