/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.common.reporter.upload;

import android.content.Context;
import com.tencent.bugly.common.reporter.IReporter;
import com.tencent.bugly.common.reporter.data.ReportData;
import com.tencent.bugly.common.reporter.upload.FileUploadRunnable;
import com.tencent.bugly.common.reporter.upload.JsonUploadRunnable;
import com.tencent.bugly.common.reporter.upload.UploadCallback;
import com.tencent.bugly.common.utils.ProcessUtil;
import com.tencent.bugly.proguard.cf;
import com.tencent.bugly.proguard.q;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0002J\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014J \u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u001a\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J \u0010 \u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u001a\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lcom/tencent/bugly/common/reporter/upload/UploadProxy;", "Lcom/tencent/bugly/common/reporter/IReporter;", "context", "Landroid/content/Context;", "appId", "", "(Landroid/content/Context;Ljava/lang/String;)V", "mAppId", "getMAppId", "()Ljava/lang/String;", "setMAppId", "(Ljava/lang/String;)V", "mContext", "getMContext", "()Landroid/content/Context;", "setMContext", "(Landroid/content/Context;)V", "checkAttrBeforeReport", "", "reportData", "Lcom/tencent/bugly/common/reporter/data/ReportData;", "getContext", "getFileUploadUrl", "reportType", "", "getJsonUploadUrl", "getMD5Params", "reportFile", "url", "callback", "Lcom/tencent/bugly/common/reporter/IReporter$ReportCallback;", "reportForVersion1", "reportJson", "reportNow", "", "bugly-pro_release"})
public final class UploadProxy
implements IReporter {
    @Nullable
    private Context mContext;
    @Nullable
    private String mAppId;

    @Nullable
    public final Context getMContext() {
        return this.mContext;
    }

    public final void setMContext(@Nullable Context context) {
        this.mContext = context;
    }

    @Nullable
    public final String getMAppId() {
        return this.mAppId;
    }

    public final void setMAppId(@Nullable String string) {
        this.mAppId = string;
    }

    public final void reportJson(@NotNull ReportData reportData, @NotNull String string, @Nullable IReporter.ReportCallback reportCallback) {
        Intrinsics.checkParameterIsNotNull((Object)reportData, (String)"reportData");
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"url");
        reportCallback = new UploadCallback(reportData, reportCallback);
        new JsonUploadRunnable(new URL(string), reportData, reportCallback).request();
    }

    public final void reportFile(@NotNull ReportData reportData, @NotNull String string, @Nullable IReporter.ReportCallback reportCallback) {
        Intrinsics.checkParameterIsNotNull((Object)reportData, (String)"reportData");
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"url");
        reportCallback = new UploadCallback(reportData, reportCallback);
        new FileUploadRunnable(new URL(string), reportData, reportCallback).request();
    }

    private final Context getContext() {
        if (this.mContext != null) {
            return this.mContext;
        }
        return cf.aI();
    }

    private final void checkAttrBeforeReport(ReportData reportData) {
        if (reportData.getParams().has("Attributes")) {
            Context context = this.getContext();
            if (!(reportData = reportData.getParams().getJSONObject("Attributes")).has("process_name")) {
                reportData.put("process_name", ProcessUtil.Companion.aS());
            }
            if (!reportData.has("is64bit") && context != null) {
                reportData.put("is64bit", ProcessUtil.Companion.is64BitProcess(context));
            }
        }
    }

    @Override
    public final boolean reportNow(@NotNull ReportData reportData, @Nullable IReporter.ReportCallback reportCallback) {
        boolean bl2;
        Intrinsics.checkParameterIsNotNull((Object)reportData, (String)"reportData");
        try {
            bl2 = false;
            this.checkAttrBeforeReport(reportData);
            if (reportData.getReportType() == 1) {
                this.reportForVersion1(reportData, reportCallback);
                bl2 = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl2 = false;
        }
        return bl2;
    }

    @NotNull
    public final String getJsonUploadUrl(int n2) {
        String string = "";
        if (n2 == 1) {
            string = q.getDomain() + "/v1/" + this.mAppId + "/upload-json";
        }
        return string;
    }

    @NotNull
    public final String getFileUploadUrl(int n2) {
        String string = "";
        if (n2 == 1) {
            string = q.getDomain() + "/v1/" + this.mAppId + "/upload-file";
        }
        return string;
    }

    @NotNull
    public final String getMD5Params(@NotNull ReportData object) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"reportData");
        long l2 = System.currentTimeMillis();
        object = ((ReportData)object).getParams().optString("client_identify", "clientidnull");
        return "?timestamp=" + l2 + "&nonce=" + (String)object;
    }

    private final void reportForVersion1(ReportData reportData, IReporter.ReportCallback reportCallback) {
        if (((CharSequence)reportData.getUploadFilePath()).length() == 0) {
            String string = this.getJsonUploadUrl(reportData.getReportType()) + this.getMD5Params(reportData);
            this.reportJson(reportData, string, reportCallback);
            return;
        }
        String string = this.getFileUploadUrl(reportData.getReportType()) + this.getMD5Params(reportData);
        this.reportFile(reportData, string, reportCallback);
    }

    public UploadProxy(@Nullable Context context, @Nullable String string) {
        this.mContext = context;
        this.mAppId = string;
    }
}

