/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.ChannelsAddRequest;
import com.tencent.ads.model.ChannelsAddResponse;
import com.tencent.ads.model.ChannelsGetRequest;
import com.tencent.ads.model.ChannelsGetResponse;
import com.tencent.ads.model.ChannelsUpdateRequest;
import com.tencent.ads.model.ChannelsUpdateResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class ChannelsApi {
    private ApiClient apiClient;

    public ChannelsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ChannelsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call channelsAddCall(ChannelsAddRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ChannelsAddRequest localVarPostBody = data;
        String localVarPath = "/channels/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call channelsAddValidateBeforeCall(ChannelsAddRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling channelsAdd(Async)");
        }
        Call call = this.channelsAddCall(data, progressListener, progressRequestListener);
        return call;
    }

    public ChannelsAddResponse channelsAdd(ChannelsAddRequest data) throws ApiException {
        ApiResponse<ChannelsAddResponse> resp = this.channelsAddWithHttpInfo(data);
        return resp.getData();
    }

    public ApiResponse<ChannelsAddResponse> channelsAddWithHttpInfo(ChannelsAddRequest data) throws ApiException {
        Call call = this.channelsAddValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<ChannelsAddResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call channelsAddAsync(ChannelsAddRequest data, final ApiCallback<ChannelsAddResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.channelsAddValidateBeforeCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ChannelsAddResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call channelsGetCall(ChannelsGetRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ChannelsGetRequest localVarPostBody = data;
        String localVarPath = "/channels/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call channelsGetValidateBeforeCall(ChannelsGetRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling channelsGet(Async)");
        }
        Call call = this.channelsGetCall(data, progressListener, progressRequestListener);
        return call;
    }

    public ChannelsGetResponse channelsGet(ChannelsGetRequest data) throws ApiException {
        ApiResponse<ChannelsGetResponse> resp = this.channelsGetWithHttpInfo(data);
        return resp.getData();
    }

    public ApiResponse<ChannelsGetResponse> channelsGetWithHttpInfo(ChannelsGetRequest data) throws ApiException {
        Call call = this.channelsGetValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<ChannelsGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call channelsGetAsync(ChannelsGetRequest data, final ApiCallback<ChannelsGetResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.channelsGetValidateBeforeCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ChannelsGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call channelsUpdateCall(ChannelsUpdateRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ChannelsUpdateRequest localVarPostBody = data;
        String localVarPath = "/channels/update";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call channelsUpdateValidateBeforeCall(ChannelsUpdateRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling channelsUpdate(Async)");
        }
        Call call = this.channelsUpdateCall(data, progressListener, progressRequestListener);
        return call;
    }

    public ChannelsUpdateResponse channelsUpdate(ChannelsUpdateRequest data) throws ApiException {
        ApiResponse<ChannelsUpdateResponse> resp = this.channelsUpdateWithHttpInfo(data);
        return resp.getData();
    }

    public ApiResponse<ChannelsUpdateResponse> channelsUpdateWithHttpInfo(ChannelsUpdateRequest data) throws ApiException {
        Call call = this.channelsUpdateValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<ChannelsUpdateResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call channelsUpdateAsync(ChannelsUpdateRequest data, final ApiCallback<ChannelsUpdateResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.channelsUpdateValidateBeforeCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ChannelsUpdateResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

