/*
 * Decompiled with CFR 0.152.
 */
package com.tempos21.t21crypt.crypter;

import com.tempos21.t21crypt.crypter.Crypter;
import com.tempos21.t21crypt.exception.CrypterException;
import com.tempos21.t21crypt.exception.DecrypterException;
import com.tempos21.t21crypt.exception.EncrypterException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class AESCrypter
implements Crypter {
    private static final String AES_KEY_ALGORITHM = "AES";
    private static final String AES_TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final String ENCODING = "UTF-8";
    private static final String PASS_HASH_ALGORITHM = "SHA-256";
    private static final String KEY_CANNOT_BE_NULL = "Key cannot be null";
    private static final String TEXT_CANNOT_BE_NULL = "Text cannot be null";
    private static final String KEY_INVALID_SIZE = "Invalid key? Have you tried to install JCE? Take a look to Javadoc :)";
    private static AESCrypter INSTANCE;
    private Cipher cipher;
    private SecretKeySpec secretKeySpec;

    public static AESCrypter getInstance(String key) throws CrypterException {
        if (key == null) {
            throw new CrypterException(KEY_CANNOT_BE_NULL);
        }
        if (INSTANCE == null) {
            INSTANCE = new AESCrypter(key);
        }
        return INSTANCE;
    }

    private AESCrypter(String key) throws CrypterException {
        try {
            this.cipher = this.getCipher();
            this.secretKeySpec = this.getKey(this.buildKey(key));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new CrypterException(e.getMessage());
        }
    }

    @Override
    public String encrypt(String plainText) throws EncrypterException {
        String encryptedString;
        if (plainText == null) {
            throw new EncrypterException(TEXT_CANNOT_BE_NULL);
        }
        try {
            IvParameterSpec ivSpec = this.getIvParameterSpec(this.createRandomIvBytes());
            this.cipher.init(1, (Key)this.secretKeySpec, ivSpec);
            byte[] encryptedBytes = this.cipher.doFinal(plainText.getBytes(ENCODING));
            int totalLength = this.getBlockSize() + encryptedBytes.length;
            byte[] finalEncryptedBytes = new byte[totalLength];
            System.arraycopy(ivSpec.getIV(), 0, finalEncryptedBytes, 0, this.getBlockSize());
            System.arraycopy(encryptedBytes, 0, finalEncryptedBytes, this.getBlockSize(), encryptedBytes.length);
            encryptedString = new String(Base64.encodeBase64((byte[])finalEncryptedBytes), ENCODING);
        }
        catch (InvalidKeyException e) {
            throw new EncrypterException(KEY_INVALID_SIZE);
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | BadPaddingException | IllegalBlockSizeException e) {
            throw new EncrypterException(e.getMessage());
        }
        return encryptedString;
    }

    @Override
    public String decrypt(String cryptedText) throws DecrypterException {
        String decryptedToken;
        if (cryptedText == null) {
            throw new DecrypterException(TEXT_CANNOT_BE_NULL);
        }
        try {
            byte[] cryptedTextBytes = Base64.decodeBase64((byte[])cryptedText.getBytes(ENCODING));
            byte[] ivBytes = new byte[this.getBlockSize()];
            int cryptedTextBytesLength = cryptedTextBytes.length - this.getBlockSize();
            byte[] finalCryptedTextBytes = new byte[cryptedTextBytesLength];
            System.arraycopy(cryptedTextBytes, 0, ivBytes, 0, this.getBlockSize());
            System.arraycopy(cryptedTextBytes, this.getBlockSize(), finalCryptedTextBytes, 0, cryptedTextBytesLength);
            IvParameterSpec ivParameterSpec = this.getIvParameterSpec(ivBytes);
            this.cipher.init(2, (Key)this.secretKeySpec, ivParameterSpec);
            byte[] decryptedBytes = this.cipher.doFinal(finalCryptedTextBytes);
            decryptedToken = new String(decryptedBytes, ENCODING);
        }
        catch (InvalidKeyException e) {
            throw new DecrypterException("Invalid key? Have you tried to install JCE? Take a look to Javadoc :) - Error message: " + e.getMessage());
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | BadPaddingException | IllegalBlockSizeException e) {
            throw new DecrypterException(e.getMessage());
        }
        return decryptedToken;
    }

    private byte[] buildKey(String key) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digester = MessageDigest.getInstance(PASS_HASH_ALGORITHM);
        digester.update(key.getBytes(ENCODING));
        byte[] keyBytes = new byte[this.getBlockSize()];
        System.arraycopy(digester.digest(), 0, keyBytes, 0, keyBytes.length);
        return keyBytes;
    }

    private int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    private IvParameterSpec getIvParameterSpec(byte[] iv) {
        return new IvParameterSpec(iv);
    }

    private byte[] createRandomIvBytes() {
        byte[] iv = new byte[this.getBlockSize()];
        new SecureRandom().nextBytes(iv);
        return iv;
    }

    private Cipher getCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance(AES_TRANSFORMATION);
    }

    private SecretKeySpec getKey(byte[] keyBytes) {
        return new SecretKeySpec(keyBytes, AES_KEY_ALGORITHM);
    }
}

