/*
 * Decompiled with CFR 0.152.
 */
package com.tempos21.t21crypt.crypter;

import android.util.Base64;
import android.util.Log;
import com.tempos21.t21crypt.cipher.AES256Cipher;
import com.tempos21.t21crypt.crypter.OldCrypter;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class AES256Crypter
implements OldCrypter {
    private static final String ENCODING = "UTF-8";
    private static final String PASS_HASH_ALGORITHM = "SHA-256";

    @Override
    public String encrypt(String key, String plainText) {
        byte[] encryptedBytes = new byte[]{};
        try {
            encryptedBytes = AES256Cipher.encrypt(this.buildKey(key), plainText.getBytes(ENCODING));
        }
        catch (Exception e) {
            Log.e((String)"ERROR while encrypting", (String)e.toString());
        }
        return Base64.encodeToString((byte[])encryptedBytes, (int)0);
    }

    @Override
    public String decrypt(String key, String cryptedText) {
        String decryptedToken = null;
        try {
            byte[] decryptedBytes = AES256Cipher.decrypt(this.buildKey(key), Base64.decode((byte[])cryptedText.getBytes(ENCODING), (int)0));
            decryptedToken = new String(decryptedBytes, ENCODING);
        }
        catch (Exception e) {
            Log.e((String)"ERROR while encrypting", (String)e.toString());
        }
        return decryptedToken;
    }

    private byte[] buildKey(String key) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digester = MessageDigest.getInstance(PASS_HASH_ALGORITHM);
        digester.update(key.getBytes(ENCODING));
        return digester.digest();
    }
}

