/*
 * Decompiled with CFR 0.152.
 */
package com.tempos21.android.commons.utils;

import android.util.Log;

public class T21Log {
    private static final String BLANK = " ";
    private static boolean LOG_ENABLED = false;
    private static String logTag = null;

    public static String getLogTag() {
        if (logTag == null) {
            return T21Log.class.getPackage().getName();
        }
        return logTag;
    }

    public static void initialize(String tag, boolean enabled) {
        logTag = tag;
        LOG_ENABLED = enabled;
    }

    private static String getString(Object object) {
        String string = null;
        try {
            string = String.valueOf(object);
        }
        catch (Exception e) {
            try {
                string = object.toString();
            }
            catch (Exception e1) {
                Log.e((String)T21Log.getLogTag(), (String)e1.getMessage());
            }
            Log.e((String)T21Log.getLogTag(), (String)e.getMessage());
        }
        return string;
    }

    public static void v(Object ... verbose) {
        if (LOG_ENABLED) {
            Log.v((String)T21Log.getLogTag(), (String)T21Log.getLog(verbose));
        }
    }

    public static void d(Object ... debug) {
        if (LOG_ENABLED) {
            Log.d((String)T21Log.getLogTag(), (String)T21Log.getLog(debug));
        }
    }

    public static void i(Object ... info) {
        if (LOG_ENABLED) {
            Log.i((String)T21Log.getLogTag(), (String)T21Log.getLog(info));
        }
    }

    public static void w(Object ... warning) {
        if (LOG_ENABLED) {
            Log.w((String)T21Log.getLogTag(), (String)T21Log.getLog(warning));
        }
    }

    public static void e(Object ... error) {
        if (LOG_ENABLED) {
            Log.e((String)T21Log.getLogTag(), (String)T21Log.getLog(error));
        }
    }

    private static String getLog(Object ... objects) {
        StringBuilder sb = new StringBuilder();
        boolean space = false;
        for (Object object : objects) {
            if (space) {
                sb.append(BLANK);
            }
            sb.append(T21Log.getString(object));
            space = true;
        }
        return sb.toString();
    }
}

