/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.telephony.support.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Configuration;
import android.provider.Settings;

public class SettingsUtil {
    private Context context;
    private ContentResolver resolver;
    private static SettingsUtil settingsUtil;

    public static SettingsUtil getInstance() {
        if (settingsUtil == null) {
            settingsUtil = new SettingsUtil();
        }
        return settingsUtil;
    }

    public void init(Context context) {
        this.context = context;
        this.resolver = context.getContentResolver();
    }

    public void setDialInterval(int interval) {
        this.putInt("telephony_dial_interval", interval);
    }

    public int getDialInterval() {
        return this.getInt("telephony_dial_interval", 2500);
    }

    public void setFlashLength(int length) {
        this.putInt("telephony_flash_length", length);
    }

    public int getFlashLength() {
        return this.getInt("telephony_flash_length", 300);
    }

    public void setPowerOn(boolean on) {
        this.putInt("telephony_power_on", on ? 1 : 0);
    }

    public boolean isPowerOn() {
        int on = this.getInt("telephony_power_on");
        return on == 1;
    }

    public void setLedOn(boolean on) {
        this.putInt("telephony_led_on", on ? 1 : 0);
    }

    public boolean isLedOn() {
        int on = this.getInt("telephony_led_on");
        return on == 1;
    }

    private void putInt(String key, int value) {
        Settings.System.putInt((ContentResolver)this.resolver, (String)key, (int)value);
    }

    private int getInt(String key) {
        return this.getInt(key, 0);
    }

    private int getInt(String key, int value) {
        return Settings.System.getInt((ContentResolver)this.resolver, (String)key, (int)value);
    }

    private void putString(String key, String value) {
        Settings.System.putString((ContentResolver)this.resolver, (String)key, (String)value);
    }

    private void putConfiguration(Configuration config) {
        Settings.System.putConfiguration((ContentResolver)this.resolver, (Configuration)config);
    }
}

