/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.telephony.support.util;

import android.media.ToneGenerator;

public class DtmfUtil {
    private static final int DTMF_DURATION_MS = 100;
    public static ToneGenerator toneGenerator = new ToneGenerator(8, 100);

    public static void playTone(String sequence) {
        char[] seq = sequence.toCharArray();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (char tone : seq) {
            DtmfUtil.playTone(DtmfUtil.getDTMFTone(tone));
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static int getDTMFTone(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case '*': {
                return 10;
            }
            case '#': {
                return 11;
            }
            case '+': {
                return 0;
            }
            case 'A': {
                return 12;
            }
            case 'B': {
                return 13;
            }
            case 'C': {
                return 14;
            }
            case 'D': {
                return 15;
            }
        }
        return 0;
    }

    public static void playTone(int tone) {
        if (toneGenerator == null) {
            return;
        }
        toneGenerator.startTone(tone, 100);
    }

    public static void playTone(int tone, int duration) {
        if (toneGenerator == null) {
            return;
        }
        toneGenerator.startTone(tone, duration);
    }

    public static void playDialTone() {
        DtmfUtil.playTone(16, -1);
    }

    public static void stopTone() {
        toneGenerator.stopTone();
    }

    public static void playRingTone() {
        DtmfUtil.playTone(23, -1);
    }
}

