/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.telephony.support.helper;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import com.telpo.telephony.project.config.TelephonyVariable;
import com.telpo.telephony.project.model.Call;
import com.telpo.telephony.project.module.proxy.IProxy;
import com.telpo.telephony.project.module.proxy.ProxyCallState;

public class ProxyHelper {
    private static IProxy proxy;

    public static IProxy getProxy() {
        return proxy;
    }

    public static void setProxy(IProxy xproxy) {
        proxy = xproxy;
    }

    public static void setProxy(String proxyclass) {
        try {
            Class<?> clz = Class.forName(proxyclass);
            Object obj = clz.newInstance();
            if (obj instanceof IProxy) {
                proxy = (IProxy)obj;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void setProxy(Class clz) {
        try {
            Object obj = clz.newInstance();
            if (obj instanceof IProxy) {
                proxy = (IProxy)obj;
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void handleProxyAction(String action) {
        if (ProxyHelper.getProxy() == null) {
            return;
        }
        switch (action) {
            case "telpo.call.action.accept": {
                ProxyHelper.getProxy().accept();
                break;
            }
            case "telpo.call.action.hangup": {
                ProxyHelper.getProxy().hangup();
            }
        }
    }

    public static void notifyServiceState(Context context, boolean on) {
        Intent intent = new Intent();
        intent.addCategory(context.getPackageName());
        intent.setAction("telpo.intent.action.ACTION_TELEPHONY_CHANGED");
        intent.putExtra("TELEPHONY_STATE", on);
        context.sendBroadcast(intent);
    }

    public static void notifyCallState(Context context) {
        ProxyHelper.notifyCallState(context, null);
    }

    public static void notifyCallState(Context context, Call call) {
        IProxy proxy = ProxyHelper.getProxy();
        ProxyHelper.notifyCallState(context, proxy, call);
    }

    public static void notifyCallState(Context context, IProxy proxy, Call call) {
        if (proxy == null) {
            return;
        }
        ProxyCallState state = proxy.getCallsNb() == 0 ? ProxyCallState.IDLE : (proxy.isIncoming() ? ProxyCallState.RINGING : ProxyCallState.OFFHOOK);
        if (call != null) {
            ProxyHelper.notifyCallState(context, state, call);
        } else {
            ProxyHelper.notifyCallState(context, state, null);
        }
    }

    private static void notifyCallState(Context context, ProxyCallState state, Call call) {
        String callstate;
        Intent intent = new Intent();
        intent.addCategory(context.getPackageName());
        intent.setAction("telpo.intent.action.CALL_STATE");
        switch (state) {
            case IDLE: {
                callstate = "CALL_STATE_IDLE";
                break;
            }
            case RINGING: {
                callstate = "CALL_STATE_RINGING";
                break;
            }
            case OFFHOOK: {
                callstate = "CALL_STATE_OFFHOOK";
                break;
            }
            default: {
                return;
            }
        }
        intent.putExtra("CALL_STATE", callstate);
        if (call != null) {
            intent.putExtra("CALL_MODE", call.getMode());
            if (TelephonyVariable.Proxy.useBundle) {
                intent.putExtra("CALL_PACK_TYPE", 1);
                intent.putExtra("CALL", ProxyHelper.generateCallBundle(call));
            } else {
                intent.putExtra("CALL_PACK_TYPE", 2);
                intent.putExtra("CALL_TYPE", call.getClass().getSimpleName());
                intent.putExtra("CALL", (Parcelable)call);
            }
        } else {
            intent.putExtra("CALL_MODE", -1);
            intent.putExtra("CALL_PACK_TYPE", 0);
        }
        context.sendBroadcast(intent);
    }

    private static Bundle generateCallBundle(Call call) {
        Bundle bundle = new Bundle();
        bundle.putString("callid", call.getId());
        bundle.putString("number", call.getRemoteNumber());
        bundle.putBoolean("direction", call.isDirection());
        bundle.putLong("duration", call.getDuration());
        bundle.putInt("recordstate", call.getRecordState().ordinal());
        bundle.putString("recordfile", call.getRecordFile());
        return bundle;
    }
}

