/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.telephony.project.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.telpo.telephony.project.model.CallState;
import com.telpo.telephony.project.model.RecordState;

public class Call
implements Parcelable {
    int mode = -1;
    String id;
    CallState state = CallState.Idle;
    String from;
    String to;
    boolean direction;
    long duration;
    String recordFile = "";
    RecordState recordState = RecordState.IDLE;
    boolean edge = false;
    public static final Parcelable.Creator<Call> CREATOR = new Parcelable.Creator<Call>(){

        public Call createFromParcel(Parcel source) {
            return new Call(source);
        }

        public Call[] newArray(int size) {
            return new Call[size];
        }
    };

    public Call() {
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRemoteNumber() {
        if (this.isDirection()) {
            return this.getTo();
        }
        return this.getFrom();
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public boolean isDirection() {
        return this.direction;
    }

    public void setDirection(boolean direction) {
        this.direction = direction;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public CallState getState() {
        return this.state;
    }

    public void setState(CallState state) {
        this.state = state;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getRecordFile() {
        return this.recordFile;
    }

    public void setRecordFile(String recordFile) {
        this.recordFile = recordFile;
    }

    public RecordState getRecordState() {
        return this.recordState;
    }

    public void setRecordState(RecordState recordState) {
        this.recordState = recordState;
    }

    public boolean isEdge() {
        return this.edge;
    }

    public void setEdge(boolean edge) {
        this.edge = edge;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mode);
        dest.writeString(this.id);
        dest.writeInt(this.state == null ? -1 : this.state.ordinal());
        dest.writeString(this.from);
        dest.writeString(this.to);
        dest.writeByte(this.direction ? (byte)1 : 0);
        dest.writeLong(this.duration);
        dest.writeString(this.recordFile);
        dest.writeInt(this.recordState == null ? -1 : this.recordState.ordinal());
    }

    protected Call(Parcel in) {
        this.mode = in.readInt();
        this.id = in.readString();
        int tmpState = in.readInt();
        this.state = tmpState == -1 ? null : CallState.values()[tmpState];
        this.from = in.readString();
        this.to = in.readString();
        this.direction = in.readByte() != 0;
        this.duration = in.readLong();
        this.recordFile = in.readString();
        int tmpRecordState = in.readInt();
        this.recordState = tmpRecordState == -1 ? null : RecordState.values()[tmpRecordState];
    }
}

