/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.telephony.support.util;

import android.media.AudioManager;
import com.telpo.telephony.support.util.XShell;
import java.lang.reflect.Method;

public class DeviceUtil {
    public void enablePlayback(AudioManager am, boolean enable) {
        if (enable && !am.isWiredHeadsetOn()) {
            DeviceUtil.setWiredDeviceConnectionState(am, 4, 1, "");
            DeviceUtil.setWiredDeviceConnectionState(am, 8, 1, "");
        } else if (!enable && am.isWiredHeadsetOn()) {
            DeviceUtil.setWiredDeviceConnectionState(am, 4, 0, "");
            DeviceUtil.setWiredDeviceConnectionState(am, 8, 0, "");
        }
    }

    public boolean isPlayback(AudioManager am) {
        return am.isWiredHeadsetOn();
    }

    public static void activeHeadset(AudioManager am) {
        if (am.isWiredHeadsetOn()) {
            return;
        }
        DeviceUtil.setWiredDeviceConnectionState(am, 4, 1, "");
    }

    public static void setWiredDeviceConnectionState(AudioManager am, int device, int state, String name) {
        try {
            Method hook = am.getClass().getMethod("setWiredDeviceConnectionState", Integer.TYPE, Integer.TYPE, String.class);
            hook.invoke((Object)am, device, state, name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void incoming(boolean incoming) {
        DeviceUtil.hwctrl_led("incoming_call", incoming ? "1" : "0");
    }

    public static void hook(boolean hook) {
        DeviceUtil.hwctrl_led("hook", hook ? "1" : "0");
    }

    public static void handsfree(boolean on) {
        DeviceUtil.hwctrl_led("hand_free", on ? "1" : "0");
    }

    public static void missed(boolean missed) {
        DeviceUtil.hwctrl_led("missed_call", missed ? "1" : "0");
    }

    public static void link(boolean link) {
        DeviceUtil.hwctrl_led("pstn_linked", link ? "1" : "0");
    }

    public static void charge(boolean on) {
        DeviceUtil.hwctrl_led("charge", on ? "1" : "0");
    }

    public static void battery(boolean low) {
        DeviceUtil.hwctrl_led("battery_low", low ? "1" : "0");
    }

    public static void hwctrl_led(String domain, String param) {
        XShell.exec("hwctrl led " + domain + " " + param);
    }
}

