/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.telephony.project.module;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.IBinder;
import com.telpo.telephony.IPstn;
import com.telpo.telephony.ITelephony;
import com.telpo.telephony.project.model.Call;
import com.telpo.telephony.project.model.CallLog;
import com.telpo.telephony.project.model.CallMode;
import com.telpo.telephony.project.model.action.CallLogAction;
import com.telpo.telephony.project.model.action.CallModeAction;
import com.telpo.telephony.project.model.action.CallStateAction;
import com.telpo.telephony.project.model.action.DtmfAction;
import com.telpo.telephony.project.model.action.ServiceConnectAction;
import com.telpo.telephony.project.module.ITelephonyListener;
import com.telpo.telephony.project.module.IdleTelephony;
import com.telpo.telephony.project.module.predux.Action;
import com.telpo.telephony.project.module.predux.Store;
import com.telpo.telephony.project.reducer.BaseTelephonyReducer;
import com.telpo.telephony.support.util.XLog;
import java.util.ArrayList;
import java.util.List;

public class TelephonyManager {
    private String TAG = "wx.manager.telephony";
    private String BINDER_PKG = "com.telpo.telephony";
    private String BINDER_CLS = "com.telpo.telephony.app.service.TelephonyService";
    private ComponentName componentName = new ComponentName(this.BINDER_PKG, this.BINDER_CLS);
    private Context context;
    private Store store = new Store();
    private static TelephonyManager manager;
    private ITelephony telephony;
    private IPstn pstn;
    private IdleTelephony idleTelephony;
    private List<ITelephonyListener> listeners = new ArrayList<ITelephonyListener>();
    private ServiceConnection conn = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            XLog.i(TelephonyManager.this.TAG, "onServiceConnected " + name.toShortString() + ",service=" + service);
            TelephonyManager.this.telephony = ITelephony.Stub.asInterface(service);
            TelephonyManager.this.initReceiver();
            TelephonyManager.this.notifyServiceConnected();
        }

        public void onServiceDisconnected(ComponentName name) {
            XLog.i(TelephonyManager.this.TAG, "onServiceDisconnected");
            TelephonyManager.this.releaseReceiver();
            TelephonyManager.this.telephony = null;
        }
    };
    private ServiceConnection pstnconn = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder service) {
            XLog.i(TelephonyManager.this.TAG, "onServiceConnected pstn ,service=" + service);
            TelephonyManager.this.pstn = IPstn.Stub.asInterface(service);
        }

        public void onServiceDisconnected(ComponentName componentName) {
            XLog.i(TelephonyManager.this.TAG, "onServiceDisconnected pstn");
            TelephonyManager.this.pstn = null;
        }
    };
    TelephonyReceiver receiver = new TelephonyReceiver();

    public Store getStore() {
        return this.store;
    }

    public void dispatch(Action action) {
        this.store.dispatch(action);
    }

    public static TelephonyManager getInstance() {
        if (manager == null) {
            manager = new TelephonyManager();
        }
        return manager;
    }

    public void init(Context context) {
        if (this.context == null) {
            this.context = context;
        }
        if (this.idleTelephony == null) {
            this.idleTelephony = new IdleTelephony(context);
        }
        this.initTelephony();
        this.initPstn();
    }

    private void initTelephony() {
        if (this.telephony != null) {
            return;
        }
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.putExtra("VERSION_CODE", 2);
        intent.putExtra("VERSION_NAME", "1.0.3");
        intent.setAction("telpo.intent.action.telephony.main");
        intent.setComponent(this.componentName);
        this.context.bindService(intent, this.conn, 1);
    }

    private void initPstn() {
        if (this.pstn != null) {
            return;
        }
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.putExtra("VERSION_CODE", 2);
        intent.putExtra("VERSION_NAME", "1.0.3");
        intent.setAction("telpo.intent.action.telephony.pstn");
        intent.setComponent(this.componentName);
        this.context.bindService(intent, this.pstnconn, 1);
    }

    public ITelephony getTelephony() {
        if (this.telephony != null) {
            return this.telephony;
        }
        return this.idleTelephony;
    }

    public IPstn getPstn() {
        if (this.pstn != null) {
            return this.pstn;
        }
        return this.idleTelephony;
    }

    public void addReducer(BaseTelephonyReducer reducer) {
        this.getStore().addReducer(reducer);
    }

    public void removeReducer(BaseTelephonyReducer reducer) {
        this.getStore().removeReducer(reducer);
    }

    public void addListener(ITelephonyListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ITelephonyListener listener) {
        this.listeners.remove(listener);
    }

    private void initReceiver() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("wx.intent.action.CALL_STATE");
        filter.addAction("wx.intent.action.ACTION_TELEPHONY_CHANGED");
        filter.addAction("wx.intent.action.CALL_LOG");
        filter.addAction("wx.intent.action.CALL_DTMF");
        this.context.registerReceiver((BroadcastReceiver)this.receiver, filter);
    }

    private void releaseReceiver() {
        this.context.unregisterReceiver((BroadcastReceiver)this.receiver);
    }

    protected void notifyServiceConnected() {
        XLog.i(this.TAG, "notifyServiceConnected");
        ServiceConnectAction action = new ServiceConnectAction();
        this.dispatch(action);
    }

    private class TelephonyReceiver
    extends BroadcastReceiver {
        private TelephonyReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            XLog.i(TelephonyManager.this.TAG, "onReceive ");
            String action = intent.getAction();
            if (action.equals("wx.intent.action.CALL_STATE")) {
                boolean isEdge = intent.getBooleanExtra("EDGE_TRIGGER", false);
                Call call = (Call)intent.getParcelableExtra("CALL_STATE");
                if (call != null) {
                    this.handleCallState(call, isEdge);
                }
            } else if (action.equals("wx.intent.action.ACTION_TELEPHONY_CHANGED")) {
                CallMode callMode = (CallMode)intent.getParcelableExtra("CALL_MODE");
                if (callMode != null) {
                    this.handleCallMode(callMode);
                }
            } else if (action.equals("wx.intent.action.CALL_LOG")) {
                CallLog callLog = (CallLog)intent.getParcelableExtra("CALL_LOG");
                if (callLog != null) {
                    this.handleCallLog(callLog);
                }
            } else if (action.equals("wx.intent.action.CALL_DTMF")) {
                char c = intent.getCharExtra("CALL_DTMF", '0');
                this.handleCallDtmf(c);
            }
        }

        private void handleCallState(Call call, boolean isEdge) {
            XLog.i(TelephonyManager.this.TAG, "handleCallState " + (Object)((Object)call.getState()));
            CallStateAction action = new CallStateAction();
            call.setEdge(isEdge);
            action.setCall(call);
            action.setState(call.getState());
            action.setEdge(isEdge);
            TelephonyManager.this.dispatch(action);
            for (ITelephonyListener listener : TelephonyManager.this.listeners) {
                listener.onCallState(call);
            }
        }

        protected void handleCallState(Call call) {
            XLog.i(TelephonyManager.this.TAG, "handleCallState " + (Object)((Object)call.getState()));
            CallStateAction action = new CallStateAction();
            action.setCall(call);
            action.setState(call.getState());
            TelephonyManager.this.dispatch(action);
            for (ITelephonyListener listener : TelephonyManager.this.listeners) {
                listener.onCallState(call);
            }
        }

        protected void handleCallMode(CallMode callMode) {
            XLog.i(TelephonyManager.this.TAG, "handleCallMode " + callMode.getType());
            CallModeAction action = new CallModeAction();
            action.setCallMode(callMode);
            TelephonyManager.this.dispatch(action);
            for (ITelephonyListener listener : TelephonyManager.this.listeners) {
                listener.onCallMode(callMode);
            }
        }

        protected void handleCallLog(CallLog callLog) {
            XLog.i(TelephonyManager.this.TAG, "handleCallLog " + (Object)((Object)callLog.getStatus()));
            CallLogAction action = new CallLogAction();
            action.setCallLog(callLog);
            TelephonyManager.this.dispatch(action);
            for (ITelephonyListener listener : TelephonyManager.this.listeners) {
                listener.onCallLog(callLog);
            }
        }

        protected void handleCallDtmf(char c) {
            XLog.i(TelephonyManager.this.TAG, "handleCallDtmf " + c);
            DtmfAction action = new DtmfAction();
            action.setDtmf(c);
            TelephonyManager.this.dispatch(action);
            for (ITelephonyListener listener : TelephonyManager.this.listeners) {
                listener.onDtmf(c);
            }
        }
    }
}

