/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.telephony.app.delegate;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.telpo.telephony.app.delegate.ICallback;
import com.telpo.telephony.app.delegate.IDialer;
import com.telpo.telephony.app.delegate.IPstnCallback;
import com.telpo.telephony.support.helper.TelephonyHelper;
import com.telpo.telephony.support.util.AndroidUtil;

public class DialerDelegate
implements IDialer {
    private Context context;
    private ICallback callback;
    private BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action;
            switch (action = intent.getAction()) {
                case "wx.intent.action.ACTION_APP_EXIT": {
                    if (DialerDelegate.this.callback != null && DialerDelegate.this.callback.appExit()) {
                        return;
                    }
                    if (!(context instanceof Activity)) break;
                    if (AndroidUtil.getLauncherPackageName(context).equals(context.getPackageName())) {
                        TelephonyHelper.notifyDialerExit();
                        break;
                    }
                    ((Activity)context).moveTaskToBack(false);
                    break;
                }
                case "wx.intent.action.ACTION_OUTGOING": {
                    if (DialerDelegate.this.callback == null) {
                        return;
                    }
                    if (DialerDelegate.this.callback instanceof IPstnCallback) {
                        boolean isPstn = intent.getBooleanExtra("PSTN", false);
                        ((IPstnCallback)DialerDelegate.this.callback).updatePstnState(isPstn);
                    }
                    DialerDelegate.this.callback.outgoing();
                }
            }
        }
    };

    public DialerDelegate(Context context) {
        this.context = context;
    }

    public DialerDelegate(Context context, ICallback callback) {
        this(context);
        this.setCallback(callback);
    }

    @Override
    public void setCallback(ICallback callback) {
        this.callback = callback;
    }

    @Override
    public void notifyAPP() {
        TelephonyHelper.notifyAPP();
    }

    @Override
    public void notifyAPPExit() {
        TelephonyHelper.notifyAPPExit();
    }

    @Override
    public void notifyDialer() {
        TelephonyHelper.notifyDialer();
    }

    @Override
    public void notifyDialerExit() {
        TelephonyHelper.notifyDialerExit();
    }

    @Override
    public void notifyStopTone() {
        TelephonyHelper.notifyStopTone();
    }

    @Override
    public void registerReceiver() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("wx.intent.action.ACTION_APP_EXIT");
        filter.addAction("wx.intent.action.ACTION_OUTGOING");
        this.context.registerReceiver(this.receiver, filter);
    }

    @Override
    public void unregisterReceiver() {
        this.context.unregisterReceiver(this.receiver);
    }
}

