/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.ui;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.os.Build;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.R;
import com.telenor.connect.ui.ConnectTextView;

public class ConnectAboutTextView
extends ConnectTextView {
    private PopupWindow popupWindow;

    public ConnectAboutTextView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initControls();
        this.initVisuals(context);
    }

    private void initControls() {
        this.setAllCaps(false);
        this.setFocusable(true);
        this.setClickable(true);
    }

    private void initVisuals(final Context context) {
        final AssetManager am = context.getApplicationContext().getAssets();
        this.setTypeface(Typeface.createFromAsset((AssetManager)am, (String)"fonts/telenorlightwebfont.ttf"));
        CharSequence linkText = this.getResources().getText(R.string.com_telenor_about_link);
        SpannableString spannableLinkText = new SpannableString(linkText);
        ClickableSpan clickableSpannableLinkText = new ClickableSpan(){

            public void onClick(@NonNull View textView) {
                ConnectAboutTextView.this.openPopup(context);
            }

            public void updateDrawState(@NonNull TextPaint ds) {
                super.updateDrawState(ds);
                ds.setTypeface(Typeface.createFromAsset((AssetManager)am, (String)"fonts/telenorboldwebfont.ttf"));
                ds.setColor(ConnectAboutTextView.this.getCurrentTextColor());
                ds.setUnderlineText(false);
            }
        };
        SpannableStringBuilder longDescription = new SpannableStringBuilder();
        longDescription.append((CharSequence)this.getResources().getString(R.string.com_telenor_about_description, new Object[]{this.getResources().getString(ConnectSdk.getIdProvider().getNameKey())}));
        spannableLinkText.setSpan((Object)clickableSpannableLinkText, 0, linkText.length(), 33);
        longDescription.append((CharSequence)spannableLinkText);
        this.setText((CharSequence)longDescription, TextView.BufferType.SPANNABLE);
        this.setMovementMethod(LinkMovementMethod.getInstance());
        this.setHighlightColor(0);
    }

    private void openPopup(Context context) {
        View view = this.getActivity().getLayoutInflater().inflate(R.layout.com_telenor_connect_about, null, false);
        if (Build.VERSION.SDK_INT < 22) {
            view.setPadding(0, this.spToPx(context, 20.0f), 0, 0);
        }
        AssetManager am = context.getApplicationContext().getAssets();
        TextView backButton = (TextView)view.findViewById(R.id.connect_about_back);
        TextView slogan = (TextView)view.findViewById(R.id.connect_about_slogan);
        TextView title = (TextView)view.findViewById(R.id.connect_about_title);
        TextView paragraph1 = (TextView)view.findViewById(R.id.connect_about_p1);
        TextView paragraph2 = (TextView)view.findViewById(R.id.connect_about_p2);
        TextView paragraph3 = (TextView)view.findViewById(R.id.connect_about_p3);
        TextView paragraph4 = (TextView)view.findViewById(R.id.connect_about_p4);
        TextView paragraph5 = (TextView)view.findViewById(R.id.connect_about_p5);
        TextView paragraph6 = (TextView)view.findViewById(R.id.connect_about_p6);
        ImageView logo = (ImageView)view.findViewById(R.id.connect_about_logo);
        backButton.setTypeface(Typeface.createFromAsset((AssetManager)am, (String)TelenorTypeface.REGULAR.getFontPath()));
        slogan.setTypeface(Typeface.createFromAsset((AssetManager)am, (String)TelenorTypeface.LIGHT.getFontPath()));
        title.setTypeface(Typeface.createFromAsset((AssetManager)am, (String)TelenorTypeface.MEDIUM.getFontPath()));
        paragraph1.setTypeface(Typeface.createFromAsset((AssetManager)am, (String)TelenorTypeface.LIGHT.getFontPath()));
        paragraph2.setTypeface(Typeface.createFromAsset((AssetManager)am, (String)TelenorTypeface.LIGHT.getFontPath()));
        paragraph3.setTypeface(Typeface.createFromAsset((AssetManager)am, (String)TelenorTypeface.LIGHT.getFontPath()));
        paragraph4.setTypeface(Typeface.createFromAsset((AssetManager)am, (String)TelenorTypeface.LIGHT.getFontPath()));
        paragraph5.setTypeface(Typeface.createFromAsset((AssetManager)am, (String)TelenorTypeface.LIGHT.getFontPath()));
        paragraph6.setTypeface(Typeface.createFromAsset((AssetManager)am, (String)TelenorTypeface.LIGHT.getFontPath()));
        title.setText((CharSequence)this.getResources().getString(R.string.com_telenor_about_screen_title, new Object[]{this.getResources().getString(ConnectSdk.getIdProvider().getNameKey())}));
        paragraph1.setText((CharSequence)this.getResources().getString(R.string.com_telenor_about_p1, new Object[]{this.getResources().getString(ConnectSdk.getIdProvider().getNameKey())}));
        paragraph2.setText((CharSequence)this.getResources().getString(R.string.com_telenor_about_p2, new Object[]{this.getResources().getString(ConnectSdk.getIdProvider().getSubscribersKey()), this.getResources().getString(ConnectSdk.getIdProvider().getNetworkKey())}));
        paragraph3.setText((CharSequence)this.getResources().getString(R.string.com_telenor_about_p3, new Object[]{this.getResources().getString(ConnectSdk.getIdProvider().getNameKey())}));
        paragraph4.setText((CharSequence)this.getResources().getString(R.string.com_telenor_about_p4, new Object[]{this.getResources().getString(ConnectSdk.getIdProvider().getNameKey())}));
        paragraph5.setText((CharSequence)this.getResources().getString(R.string.com_telenor_about_p5, new Object[]{this.getResources().getString(ConnectSdk.getIdProvider().getNameKey()), this.getResources().getString(ConnectSdk.getIdProvider().getSubscribersKey())}));
        paragraph6.setText((CharSequence)this.getResources().getString(R.string.com_telenor_about_p6, new Object[]{this.getResources().getString(ConnectSdk.getIdProvider().getNameKey())}));
        logo.setImageResource(ConnectSdk.getIdProvider().getLogoKey());
        if (this.popupWindow != null) {
            this.popupWindow.dismiss();
        }
        this.popupWindow = new PopupWindow(view, -1, -1);
        this.popupWindow.setAnimationStyle(R.style.com_telenor_popup_animation);
        this.popupWindow.showAtLocation(view, 80, 0, 0);
        backButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConnectAboutTextView.this.popupWindow.dismiss();
            }
        });
    }

    private int spToPx(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    private static enum TelenorTypeface {
        BOLD("fonts/telenorboldwebfont.ttf"),
        MEDIUM("fonts/telenormediumwebfont.ttf"),
        REGULAR("fonts/telenorregularwebfont.ttf"),
        LIGHT("fonts/telenorlightwebfont.ttf");

        String fontPath;

        private TelenorTypeface(String fontPath) {
            this.fontPath = fontPath;
        }

        public String getFontPath() {
            return this.fontPath;
        }
    }
}

