/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.id;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.telenor.connect.id.ConnectTokens;
import com.telenor.connect.id.IdToken;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;

public class ConnectStore {
    private static final String PREFERENCE_KEY_CONNECT_TOKENS = "CONNECT_TOKENS";
    private static final String PREFERENCE_KEY_DEVICE_ID = "TELENORDIGITAL_DEVICE_ID";
    private static final String PREFERENCE_KEY_ID_TOKEN = "ID_TOKEN";
    private static final String PREFERENCES_KEY_STATE = "STATE";
    private static final String PREFERENCES_KEY_STATE_EXPIRE = "STATE_EXPIRE";
    public static final String PREFERENCES_FILE = "com.telenor.connect.PREFERENCES_FILE";
    private static final Gson preferencesGson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").registerTypeAdapter(Date.class, (Object)new DateDeserializer()).create();
    private final Context context;

    public ConnectStore(Context context) {
        this.context = context;
    }

    public String handleDeviceId() {
        String deviceId = this.context.getSharedPreferences(PREFERENCES_FILE, 0).getString(PREFERENCE_KEY_DEVICE_ID, null);
        if (deviceId != null) {
            return deviceId;
        }
        String newDeviceId = UUID.randomUUID().toString();
        this.context.getSharedPreferences(PREFERENCES_FILE, 0).edit().putString(PREFERENCE_KEY_DEVICE_ID, newDeviceId).apply();
        return newDeviceId;
    }

    public String getPureDeviceId() {
        return this.context.getSharedPreferences(PREFERENCES_FILE, 0).getString(PREFERENCE_KEY_DEVICE_ID, null);
    }

    public void set(ConnectTokens connectTokens) {
        String jsonConnectTokens = preferencesGson.toJson((Object)connectTokens);
        String jsonIdToken = preferencesGson.toJson((Object)connectTokens.getIdToken());
        this.context.getSharedPreferences(PREFERENCES_FILE, 0).edit().putString(PREFERENCE_KEY_CONNECT_TOKENS, jsonConnectTokens).putString(PREFERENCE_KEY_ID_TOKEN, jsonIdToken).apply();
    }

    public void update(ConnectTokens connectTokens) {
        String jsonConnectTokens = preferencesGson.toJson((Object)connectTokens);
        this.context.getSharedPreferences(PREFERENCES_FILE, 0).edit().putString(PREFERENCE_KEY_CONNECT_TOKENS, jsonConnectTokens).apply();
    }

    public ConnectTokens get() {
        String connectTokensJson = this.context.getSharedPreferences(PREFERENCES_FILE, 0).getString(PREFERENCE_KEY_CONNECT_TOKENS, null);
        try {
            return (ConnectTokens)preferencesGson.fromJson(connectTokensJson, ConnectTokens.class);
        }
        catch (JsonSyntaxException e) {
            this.clear();
            return null;
        }
    }

    public void clear() {
        this.context.getSharedPreferences(PREFERENCES_FILE, 0).edit().clear().apply();
    }

    public IdToken getIdToken() {
        String idTokenJson = this.context.getSharedPreferences(PREFERENCES_FILE, 0).getString(PREFERENCE_KEY_ID_TOKEN, null);
        try {
            return (IdToken)preferencesGson.fromJson(idTokenJson, IdToken.class);
        }
        catch (JsonSyntaxException e) {
            this.clear();
            return null;
        }
    }

    public String generateSessionStateParam() {
        SharedPreferences sharedPreferences = this.context.getSharedPreferences(PREFERENCE_KEY_CONNECT_TOKENS, 0);
        long expireTime = sharedPreferences.getLong(PREFERENCES_KEY_STATE_EXPIRE, -1L);
        if (expireTime < System.currentTimeMillis()) {
            return this.createAndSaveNewSessionStateParam();
        }
        String state = sharedPreferences.getString(PREFERENCES_KEY_STATE, null);
        return state != null ? state : this.createAndSaveNewSessionStateParam();
    }

    private String createAndSaveNewSessionStateParam() {
        SharedPreferences sharedPreferences = this.context.getSharedPreferences(PREFERENCE_KEY_CONNECT_TOKENS, 0);
        String newStateParam = UUID.randomUUID().toString();
        Calendar calendar = Calendar.getInstance();
        calendar.add(10, 1);
        long stateExpireTime = calendar.getTimeInMillis();
        sharedPreferences.edit().putString(PREFERENCES_KEY_STATE, newStateParam).putLong(PREFERENCES_KEY_STATE_EXPIRE, stateExpireTime).apply();
        return newStateParam;
    }

    public String getSessionStateParam() {
        return this.context.getSharedPreferences(PREFERENCE_KEY_CONNECT_TOKENS, 0).getString(PREFERENCES_KEY_STATE, null);
    }

    public void clearSessionStateParam() {
        this.context.getSharedPreferences(PREFERENCE_KEY_CONNECT_TOKENS, 0).edit().remove(PREFERENCES_KEY_STATE).remove(PREFERENCES_KEY_STATE_EXPIRE).apply();
    }

    private static class DateDeserializer
    implements JsonDeserializer<Date> {
        private DateDeserializer() {
        }

        @SuppressLint(value={"SimpleDateFormat"})
        public Date deserialize(JsonElement je, Type type, JsonDeserializationContext jdc) throws JsonParseException {
            String date = je.getAsString();
            try {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parse(date);
            }
            catch (ParseException parseException) {
                try {
                    return new SimpleDateFormat("MMM d, y h:mm:ss").parse(date);
                }
                catch (ParseException parseException2) {
                    try {
                        return new SimpleDateFormat("MMM d, y h:mm:ss", Locale.US).parse(date);
                    }
                    catch (ParseException parseException3) {
                        try {
                            return DateFormat.getDateTimeInstance(2, 2).parse(date);
                        }
                        catch (ParseException parseException4) {
                            try {
                                return DateFormat.getDateTimeInstance(2, 2, Locale.US).parse(date);
                            }
                            catch (ParseException parseException5) {
                                throw new JsonParseException("Invalid date:" + date);
                            }
                        }
                    }
                }
            }
        }
    }
}

