/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.ui;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.R;
import com.telenor.connect.headerenrichment.DismissDialogCallback;
import com.telenor.connect.headerenrichment.HeLogic;
import com.telenor.connect.headerenrichment.ShowLoadingCallback;
import com.telenor.connect.id.Claims;
import com.telenor.connect.ui.AuthenticationButton;
import com.telenor.connect.ui.ConnectCustomTabLoginButton;
import com.telenor.connect.ui.TurnOnMobileDataDialogFragment;
import com.telenor.connect.utils.TurnOnMobileDataDialogAnalytics;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;

public class ConnectLoginButton
extends RelativeLayout
implements AuthenticationButton,
TurnOnMobileDataDialogFragment.ContinueListener {
    private ConnectCustomTabLoginButton loginButton;
    private ProgressBar progressBar;
    private View.OnClickListener loginClickListener;

    public ConnectLoginButton(Context context) {
        super(context);
        this.init(context);
    }

    private void init(final Context context) {
        ConnectLoginButton.inflate((Context)this.getContext(), (int)R.layout.com_telenor_connect_login_button_with_progress_bar, (ViewGroup)this);
        this.progressBar = (ProgressBar)this.findViewById(R.id.com_telenor_connect_login_button_progress_bar);
        this.loginButton = (ConnectCustomTabLoginButton)this.findViewById(R.id.com_telenor_connect_login_button);
        this.loginButton.setShowLoadingCallback(new ShowLoadingCallback(){

            @Override
            public void stop() {
                ConnectLoginButton.this.setLoading(false);
            }
        });
        this.loginClickListener = this.loginButton.getOnClickListener();
        this.loginButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                boolean showTurnOnMobileDataDialog;
                ConnectLoginButton.this.setLoading(true);
                boolean bl = showTurnOnMobileDataDialog = !ConnectLoginButton.this.mobileNetworkIsAvailable(context) && ConnectSdk.isTurnOnMobileDataDialogEnabled();
                if (!showTurnOnMobileDataDialog || HeLogic.canNotDirectNetworkTraffic) {
                    ConnectLoginButton.this.loginClickListener.onClick(v);
                    return;
                }
                final TurnOnMobileDataDialogFragment turnOnMobileDataDialogFragment = new TurnOnMobileDataDialogFragment();
                ConnectLoginButton.this.loginButton.setDismissDialogCallback(new DismissDialogCallback(){

                    @Override
                    public void dismiss() {
                        turnOnMobileDataDialogFragment.dismiss();
                    }

                    @Override
                    @RequiresApi(api=21)
                    public TurnOnMobileDataDialogAnalytics getAnalytics() {
                        return new TurnOnMobileDataDialogAnalytics(ConnectSdk.isTurnOnMobileDataDialogEnabled(), true, turnOnMobileDataDialogFragment.isAtomaticButtonPressed(), turnOnMobileDataDialogFragment.isManualButtonPressed());
                    }
                });
                FragmentManager fragmentManager = ((FragmentActivity)ConnectLoginButton.this.loginButton.getActivity()).getSupportFragmentManager();
                turnOnMobileDataDialogFragment.show(fragmentManager, "TurnOnMobileDataFragment");
                turnOnMobileDataDialogFragment.setContinueListener(ConnectLoginButton.this);
            }
        });
        if (ConnectSdk.isDoInstantVerificationOnButtonInitialize()) {
            ConnectSdk.runInstantVerification();
        }
    }

    @Deprecated
    private boolean mobileNetworkIsAvailable(Context context) {
        boolean mobileDataEnabled;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        try {
            Class<?> connectivityManagerClass = Class.forName(connectivityManager.getClass().getName());
            Method method = connectivityManagerClass.getDeclaredMethod("getMobileDataEnabled", new Class[0]);
            method.setAccessible(true);
            mobileDataEnabled = (Boolean)method.invoke((Object)connectivityManager, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return HeLogic.isCellularDataNetworkConnected();
        }
        catch (SecurityException e) {
            return HeLogic.isCellularDataNetworkConnected();
        }
        catch (Exception e) {
            return false;
        }
        return mobileDataEnabled;
    }

    private void setLoading(boolean loading) {
        this.progressBar.setVisibility(loading ? 0 : 4);
        this.loginButton.setEnabled(!loading);
    }

    @Override
    public void onContinueClicked(DialogFragment dialog) {
        this.loginClickListener.onClick(null);
    }

    @Override
    public void onCancel(DialogInterface dialog) {
        this.setLoading(false);
    }

    public ConnectLoginButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ConnectLoginButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @RequiresApi(api=21)
    public ConnectLoginButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (this.loginButton == null || this.loginButton.getActivity() == null) {
            return;
        }
        Intent intent = this.loginButton.getActivity().getIntent();
        boolean ongoingAuth = intent != null && ConnectSdk.hasValidRedirectUrlCall(intent);
        this.setLoading(ongoingAuth);
    }

    @Override
    public ArrayList<String> getAcrValues() {
        return this.loginButton.getAcrValues();
    }

    @Override
    public Map<String, String> getLoginParameters() {
        return this.loginButton.getLoginParameters();
    }

    @Override
    public ArrayList<String> getLoginScopeTokens() {
        return this.loginButton.getLoginScopeTokens();
    }

    @Override
    public int getRequestCode() {
        return this.loginButton.getRequestCode();
    }

    @Override
    public Claims getClaims() {
        return this.loginButton.getClaims();
    }

    @Override
    public int getCustomLoadingLayout() {
        return this.loginButton.getCustomLoadingLayout();
    }

    @Override
    public View.OnClickListener getOnClickListener() {
        return this.loginButton.getOnClickListener();
    }

    @Override
    public void setAcrValues(String ... acrValues) {
        this.loginButton.setAcrValues(acrValues);
    }

    @Override
    public void setAcrValues(ArrayList<String> acrValues) {
        this.loginButton.setAcrValues(acrValues);
    }

    @Override
    public void setLoginScopeTokens(String ... scopeTokens) {
        this.loginButton.setLoginScopeTokens(scopeTokens);
    }

    @Override
    public void setLoginScopeTokens(ArrayList<String> scopeTokens) {
        this.loginButton.setLoginScopeTokens(scopeTokens);
    }

    @Override
    public void setExtraLoginParameters(Map<String, String> parameters) {
        this.loginButton.setExtraLoginParameters(parameters);
    }

    @Override
    public void setRequestCode(int requestCode) {
        this.loginButton.setRequestCode(requestCode);
    }

    @Override
    public void setClaims(Claims claims) {
        this.loginButton.setClaims(claims);
    }

    @Override
    public void setCustomLoadingLayout(int customLoadingLayout) {
        this.loginButton.setCustomLoadingLayout(customLoadingLayout);
    }
}

