/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.ui;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.R;

public class WebErrorView
extends RelativeLayout {
    private TextView errorText;
    private View loadingSpinner;
    private Button tryAgain;
    private Button showMoreToggle;
    private TextView errorDetails;

    public WebErrorView(Context context) {
        super(context);
        this.init();
    }

    public WebErrorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public WebErrorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public WebErrorView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        WebErrorView.inflate((Context)this.getContext(), (int)R.layout.com_telenor_connect_error_view, (ViewGroup)this);
        TextView brandedView = (TextView)this.findViewById(R.id.com_telenor_connect_error_view_communication_error);
        brandedView.setText((CharSequence)this.getResources().getString(R.string.com_telenor_connect_error_text1, new Object[]{ConnectSdk.getIdProvider().getName()}));
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.errorText = (TextView)this.findViewById(R.id.com_telenor_connect_error_view_text);
        this.loadingSpinner = this.findViewById(R.id.com_telenor_connect_error_view_loading);
        this.tryAgain = (Button)this.findViewById(R.id.com_telenor_connect_error_view_try_again);
        this.findViewById(R.id.com_telenor_connect_error_view_network_settings).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent("android.settings.WIFI_SETTINGS");
                WebErrorView.this.getContext().startActivity(intent);
            }
        });
        this.errorDetails = (TextView)this.findViewById(R.id.com_telenor_connect_error_view_details);
        this.showMoreToggle = (Button)this.findViewById(R.id.com_telenor_connect_error_view_show_more_toggle);
        this.showMoreToggle.setPaintFlags(this.showMoreToggle.getPaintFlags() | 8);
        this.showMoreToggle.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                int newVisibility = WebErrorView.this.errorDetails.getVisibility() != 0 ? 0 : 8;
                WebErrorView.this.errorDetails.setVisibility(WebErrorView.this.errorDetails.getVisibility() != 0 ? 0 : 8);
                WebErrorView.this.showMoreToggle.setText(newVisibility != 0 ? R.string.com_telenor_connect_show_details : R.string.com_telenor_connect_hide_details);
            }
        });
    }

    public void setErrorText(String text, String details) {
        this.errorText.setText((CharSequence)(text != null ? text : ""));
        this.errorDetails.setText((CharSequence)(details != null ? details : ""));
    }

    public View getLoadingSpinner() {
        return this.loadingSpinner;
    }

    public Button getTryAgainButton() {
        return this.tryAgain;
    }
}

