/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.headerenrichment;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import com.telenor.connect.headerenrichment.HeLogic;
import java.util.Set;

public class HeFlowDecider {
    private static final String PARAMETER_PROMPT = "prompt";
    private static final String PARAMETER_NO_SEAM = "no_seam";
    private static final String PARAMETER_HE_TOKEN = "telenordigital_he_token";

    public static Uri chooseFlow(Uri uri, Context context) {
        if (context == null) {
            return uri;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (Build.VERSION.SDK_INT > 22) {
            NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(connectivityManager.getActiveNetwork());
            if (networkCapabilities != null && networkCapabilities.hasCapability(12) && networkCapabilities.hasCapability(16)) {
                if (networkCapabilities.hasTransport(1) && networkCapabilities.hasTransport(0)) {
                    if (HeLogic.failedToGetToken() || uri.getQueryParameter(PARAMETER_HE_TOKEN) == null) {
                        return uri.buildUpon().appendQueryParameter(PARAMETER_PROMPT, PARAMETER_NO_SEAM).build();
                    }
                    return HeFlowDecider.removeUriParameter(uri, PARAMETER_PROMPT);
                }
                if (networkCapabilities.hasTransport(1)) {
                    if (HeFlowDecider.hasNoSeam(uri)) {
                        return uri;
                    }
                    return uri.buildUpon().appendQueryParameter(PARAMETER_PROMPT, PARAMETER_NO_SEAM).build();
                }
                if (networkCapabilities.hasTransport(0)) {
                    if (HeFlowDecider.hasNoSeam(uri)) {
                        return HeFlowDecider.removeUriParameter(uri, PARAMETER_PROMPT);
                    }
                    return uri;
                }
            }
            return uri;
        }
        boolean isMobile = connectivityManager.getNetworkInfo(0).isConnectedOrConnecting();
        boolean isLte = connectivityManager.getNetworkInfo(5).isConnectedOrConnecting();
        boolean isWifi = connectivityManager.getNetworkInfo(1).isConnectedOrConnecting();
        if ((isMobile || isLte) && isWifi) {
            if (HeLogic.failedToGetToken() || uri.getQueryParameter(PARAMETER_HE_TOKEN) == null) {
                return uri.buildUpon().appendQueryParameter(PARAMETER_PROMPT, PARAMETER_NO_SEAM).build();
            }
            return HeFlowDecider.removeUriParameter(uri, PARAMETER_PROMPT);
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            if (networkInfo.getType() == 1) {
                if (HeFlowDecider.hasNoSeam(uri)) {
                    return uri;
                }
                return uri.buildUpon().appendQueryParameter(PARAMETER_PROMPT, PARAMETER_NO_SEAM).build();
            }
            if (networkInfo.getType() == 0 || networkInfo.getType() == 5) {
                if (HeFlowDecider.hasNoSeam(uri)) {
                    return HeFlowDecider.removeUriParameter(uri, PARAMETER_PROMPT);
                }
                return uri;
            }
        }
        return uri;
    }

    private static boolean hasNoSeam(Uri uri) {
        return PARAMETER_NO_SEAM.equals(uri.getQueryParameter(PARAMETER_PROMPT));
    }

    private static Uri removeUriParameter(Uri uri, String key) {
        Set params = uri.getQueryParameterNames();
        Uri.Builder newUri = uri.buildUpon().clearQuery();
        for (String param : params) {
            if (param.equals(key)) continue;
            newUri.appendQueryParameter(param, uri.getQueryParameter(param));
        }
        return newUri.build();
    }
}

