/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Network;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.browser.customtabs.CustomTabsSession;
import androidx.fragment.app.Fragment;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GoogleApiAvailability;
import com.telenor.connect.AnalyticsAPI;
import com.telenor.connect.BrowserType;
import com.telenor.connect.ConnectCallback;
import com.telenor.connect.ConnectException;
import com.telenor.connect.WellKnownAPI;
import com.telenor.connect.WellKnownConfigStore;
import com.telenor.connect.headerenrichment.DismissDialogCallback;
import com.telenor.connect.headerenrichment.HeLogic;
import com.telenor.connect.headerenrichment.HeTokenCallback;
import com.telenor.connect.headerenrichment.HeTokenResponse;
import com.telenor.connect.headerenrichment.ShowLoadingCallback;
import com.telenor.connect.id.AccessTokenCallback;
import com.telenor.connect.id.ConnectIdService;
import com.telenor.connect.id.ConnectStore;
import com.telenor.connect.id.IdProvider;
import com.telenor.connect.id.IdToken;
import com.telenor.connect.id.UserInfo;
import com.telenor.connect.sms.SmsBroadcastReceiver;
import com.telenor.connect.sms.SmsHandler;
import com.telenor.connect.sms.SmsPinParseUtil;
import com.telenor.connect.sms.SmsRetrieverUtil;
import com.telenor.connect.ui.ConnectActivity;
import com.telenor.connect.ui.ConnectWebFragment;
import com.telenor.connect.utils.ConnectUrlHelper;
import com.telenor.connect.utils.RestHelper;
import com.telenor.connect.utils.TurnOnMobileDataDialogAnalytics;
import com.telenor.connect.utils.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public final class ConnectSdk {
    private static final int NO_CUSTOM_LAYOUT = -1;
    private static final int SESSION_TIMEOUT_MINUTES = 10;
    private static ArrayList<Locale> sLocales;
    private static ConnectStore connectStore;
    private static WellKnownConfigStore lastSeenWellKnownConfigStore;
    private static ConnectIdService connectIdService;
    private static Context context;
    private static boolean confidentialClient;
    private static volatile WellKnownAPI.WellKnownConfig wellKnownConfig;
    private static volatile boolean isInitialized;
    private static String clientId;
    private static String redirectUri;
    private static boolean enableTurnOnMobileDataDialog;
    private static IdProvider idProvider;
    private static boolean useStaging;
    private static SmsBroadcastReceiver smsBroadcastReceiver;
    private static volatile String advertisingId;
    private static volatile long tsSdkInitialization;
    private static volatile long tsLoginButtonClicked;
    private static volatile long tsRedirectUrlInvoked;
    private static volatile long tsTokenResponseReceived;
    private static volatile String logSessionId;
    private static volatile Date logSessionIdSetTime;
    private static TurnOnMobileDataDialogAnalytics turnOnMobileDataDialogAnalytics;
    public static final String CLIENT_ID_PROPERTY = "com.telenor.connect.CLIENT_ID";
    public static final String CONFIDENTIAL_CLIENT_PROPERTY = "com.telenor.connect.CONFIDENTIAL_CLIENT";
    public static final String REDIRECT_URI_PROPERTY = "com.telenor.connect.REDIRECT_URI";
    public static final String ENABLE_TURN_ON_MOBILE_DATA_DIALOG_PROPERTY = "com.telenor.connect.ENABLE_TURN_ON_MOBILE_DATA_DIALOG";
    public static final String ACTION_LOGIN_STATE_CHANGED = "com.telenor.connect.ACTION_LOGIN_STATE_CHANGED";
    public static final String EXTRA_CONNECT_TOKENS = "com.telenor.connect.EXTRA_CONNECT_TOKENS";

    public static synchronized void authenticate(final CustomTabsSession session, final Map<String, String> parameters, final BrowserType browserType, final Activity activity, ShowLoadingCallback showLoadingCallback, DismissDialogCallback dismissDialogCallback) {
        ConnectSdk.handleButtonClickedAnalytics();
        if (dismissDialogCallback != null) {
            ConnectSdk.handleMobileDataAnalytics(dismissDialogCallback.getAnalytics());
        }
        HeTokenCallback heTokenCallback = new HeTokenCallback(){

            @Override
            public void done() {
                Uri authorizeUri = ConnectSdk.getAuthorizeUri(parameters, browserType);
                ConnectSdk.launchChromeCustomTabAuthentication(session, authorizeUri, activity);
            }
        };
        HeLogic.handleHeToken(parameters, showLoadingCallback, heTokenCallback, logSessionId, idProvider, useStaging, dismissDialogCallback);
    }

    private static void handleButtonClickedAnalytics() {
        ConnectSdk.updateLogSessionIdIfTooOld();
        tsLoginButtonClicked = System.currentTimeMillis();
    }

    private static void handleMobileDataAnalytics(TurnOnMobileDataDialogAnalytics analytics) {
        turnOnMobileDataDialogAnalytics = analytics;
    }

    private static void updateLogSessionIdIfTooOld() {
        Date _10MinutesAgo = ConnectSdk.getSessionTimeoutDate();
        if (logSessionIdSetTime.before(_10MinutesAgo)) {
            ConnectSdk.setRandomLogSessionId();
        }
    }

    private static Date getSessionTimeoutDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -10);
        return calendar.getTime();
    }

    private static Uri getAuthorizeUri(Map<String, String> parameters, BrowserType browserType) {
        boolean failedToGetToken = HeLogic.failedToGetToken();
        HeTokenResponse heTokenResponse = HeLogic.getHeTokenResponse();
        return ConnectUrlHelper.getAuthorizeUri(parameters, browserType, failedToGetToken ? null : heTokenResponse.getToken());
    }

    private static void launchChromeCustomTabAuthentication(final CustomTabsSession session, Uri authorizeUri, final Activity activity) {
        SmsRetrieverUtil.startSmsRetriever(ConnectSdk.getContext());
        smsBroadcastReceiver = new SmsBroadcastReceiver(new SmsHandler(){

            @Override
            public void receivedSms(String messageBody) {
                String pin = SmsPinParseUtil.findPin(messageBody);
                if (pin == null) {
                    return;
                }
                ConnectSdk.safeUnregisterAndRemoveBroadcastReceiver();
                String url = ConnectUrlHelper.getSubmitPinUrl(pin);
                Uri uri = Uri.parse((String)url);
                ConnectSdk.launchUrlInCustomTab(activity, session, uri);
            }
        });
        ConnectSdk.getContext().registerReceiver((BroadcastReceiver)smsBroadcastReceiver, SmsRetrieverUtil.SMS_FILTER);
        ConnectSdk.launchUrlInCustomTab(activity, session, authorizeUri);
    }

    private static void launchUrlInCustomTab(Activity activity, CustomTabsSession session, Uri uri) {
        if (activity == null) {
            Log.e((String)"ConnectSDK", (String)"Failed to launch url in custom tab: activity is null.");
            return;
        }
        CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder(session);
        CustomTabsIntent cctIntent = builder.build();
        Intent intent = cctIntent.intent;
        if (Build.VERSION.SDK_INT >= 22) {
            intent.putExtra("android.intent.extra.REFERRER", (Parcelable)Uri.parse((String)("2//" + activity.getPackageName())));
        }
        cctIntent.launchUrl((Context)activity, uri);
    }

    public static synchronized void authenticate(Activity activity, int requestCode, String ... scopeTokens) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("scope", TextUtils.join((CharSequence)" ", (Object[])scopeTokens));
        ConnectSdk.authenticate(activity, parameters, requestCode);
    }

    public static synchronized void authenticate(Activity activity, Map<String, String> parameters, int requestCode) {
        Validator.sdkInitialized();
        ConnectSdk.authenticate(activity, parameters, -1, requestCode, null, null);
    }

    public static synchronized void authenticate(final Activity activity, final Map<String, String> parameters, final int customLoadingLayout, final int requestCode, ShowLoadingCallback showLoadingCallback, DismissDialogCallback dismissDialogCallback) {
        Validator.sdkInitialized();
        ConnectSdk.handleButtonClickedAnalytics();
        if (dismissDialogCallback != null) {
            ConnectSdk.handleMobileDataAnalytics(dismissDialogCallback.getAnalytics());
        }
        HeTokenCallback heTokenCallback = new HeTokenCallback(){

            @Override
            public void done() {
                Intent intent = ConnectSdk.getAuthIntent(parameters);
                if (customLoadingLayout != -1) {
                    intent.putExtra("com.telenor.connect.CUSTOM_LOADING_SCREEN_EXTRA", customLoadingLayout);
                }
                activity.startActivityForResult(intent, requestCode);
            }
        };
        HeLogic.handleHeToken(parameters, showLoadingCallback, heTokenCallback, logSessionId, idProvider, useStaging, dismissDialogCallback);
    }

    private static Intent getAuthIntent(Map<String, String> parameters) {
        Intent intent = new Intent();
        intent.setClass(ConnectSdk.getContext(), ConnectActivity.class);
        intent.setAction("com.telenor.connect.LOGIN_ACTION");
        String mccMnc = ConnectSdk.getMccMnc();
        if (!(TextUtils.isEmpty((CharSequence)mccMnc) || wellKnownConfig == null || wellKnownConfig.getNetworkAuthenticationTargetIps().isEmpty() && wellKnownConfig.getNetworkAuthenticationTargetUrls().isEmpty())) {
            parameters.put("login_hint", String.format("MCCMNC:%s", mccMnc));
        }
        String url = ConnectSdk.getAuthorizeUri(parameters, BrowserType.WEB_VIEW).toString();
        intent.putExtra("com.telenor.connect.LOGIN_AUTH_URI", url);
        return intent;
    }

    @Deprecated
    public static Fragment getAuthFragment(Map<String, String> parameters) {
        Validator.sdkInitialized();
        ConnectWebFragment fragment = new ConnectWebFragment();
        Intent authIntent = ConnectSdk.getAuthIntent(parameters);
        String action = authIntent.getAction();
        Bundle bundle = new Bundle(authIntent.getExtras());
        bundle.putString("com.telenor.connect.ACTION_ARGUMENT", action);
        fragment.setArguments(bundle);
        fragment.setRetainInstance(true);
        return fragment;
    }

    public static synchronized void getValidAccessToken(AccessTokenCallback callback) {
        Validator.sdkInitialized();
        connectIdService.getValidAccessToken(callback);
    }

    public static synchronized String getAccessToken() {
        Validator.sdkInitialized();
        return connectIdService.getAccessToken();
    }

    public static synchronized Date getAccessTokenExpirationTime() {
        Validator.sdkInitialized();
        return connectIdService.getAccessTokenExpirationTime();
    }

    public static synchronized void getAccessTokenFromCode(String code, final ConnectCallback callback) {
        Validator.sdkInitialized();
        tsRedirectUrlInvoked = System.currentTimeMillis();
        connectIdService.getAccessTokenFromCode(code, new ConnectCallback(){

            @Override
            public void onSuccess(Object successData) {
                tsTokenResponseReceived = System.currentTimeMillis();
                if (callback != null) {
                    callback.onSuccess(successData);
                }
                ConnectSdk.sendAnalyticsData();
            }

            @Override
            public void onError(Object errorData) {
                tsTokenResponseReceived = System.currentTimeMillis();
                if (callback != null) {
                    callback.onError(errorData);
                }
                ConnectSdk.sendAnalyticsData();
            }
        });
    }

    private static void sendAnalyticsData() {
        ConnectSdk.sendAnalyticsData(null);
    }

    public static void sendAnalyticsData(Throwable throwable) {
        String accessToken;
        String analyticsEndpoint;
        try {
            analyticsEndpoint = ConnectSdk.getWellKnownConfig().getAnalyticsEndpoint();
        }
        catch (NullPointerException e) {
            Log.e((String)"ConnectSDK", (String)"Failed to send analytics data, wellKnownConfig is null.");
            return;
        }
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        String carrierName = manager != null ? manager.getNetworkOperatorName() : null;
        boolean accessTokenIsEmpty = ConnectSdk.getAccessToken() == null || ConnectSdk.getAccessToken().isEmpty();
        HashMap<String, Object> debugInformation = new HashMap<String, Object>();
        debugInformation.put("activeNetworkInfo", HeLogic.getActiveNetworkInfo());
        debugInformation.put("cellularNetworkInfo", HeLogic.getCellularNetworkInfo());
        debugInformation.put("deviceTimestamp", new Date());
        debugInformation.put("carrierName", carrierName);
        debugInformation.put("sdkVersion", "2.3.0");
        debugInformation.put("isAccessTokenEmpty", accessTokenIsEmpty);
        debugInformation.put("getNumberOfNetworkTogglesCouldHappened", HeLogic.getNumberOfNetworkTogglesCouldHappened());
        if (throwable != null) {
            debugInformation.put("exception", throwable.getMessage());
            debugInformation.put("exceptionStackTrace", throwable.getStackTrace());
        }
        if (turnOnMobileDataDialogAnalytics == null) {
            turnOnMobileDataDialogAnalytics = new TurnOnMobileDataDialogAnalytics(enableTurnOnMobileDataDialog, false, false, false);
        }
        String auth = (accessToken = ConnectSdk.getAccessToken()) != null ? "Bearer " + accessToken : null;
        String subject = ConnectSdk.getIdToken() != null ? ConnectSdk.getIdToken().getSubject() : null;
        RestHelper.getAnalyticsApi(analyticsEndpoint).sendAnalyticsData(auth, new AnalyticsAPI.SDKAnalyticsData(ConnectSdk.getApplicationName(), ConnectSdk.getApplicationVersion(), subject, ConnectSdk.getLogSessionId(), ConnectSdk.getAdvertisingId(), tsSdkInitialization, tsLoginButtonClicked, tsRedirectUrlInvoked, tsTokenResponseReceived, debugInformation, turnOnMobileDataDialogAnalytics)).enqueue((Callback)new Callback<Void>(){

            public void onResponse(Call<Void> call, Response<Void> response) {
                if (!response.isSuccessful()) {
                    Log.e((String)"ConnectSDK", (String)"Failed to send analytics data");
                }
                ConnectSdk.setRandomLogSessionId();
            }

            public void onFailure(Call<Void> call, Throwable error) {
                Log.e((String)"ConnectSDK", (String)"Failed to send analytics data", (Throwable)error);
                ConnectSdk.setRandomLogSessionId();
            }
        });
    }

    public static void setRandomLogSessionId() {
        logSessionId = UUID.randomUUID().toString();
        logSessionIdSetTime = new Date();
    }

    public static Context getContext() {
        Validator.sdkInitialized();
        return context;
    }

    public static String getClientId() {
        Validator.sdkInitialized();
        return clientId;
    }

    public static boolean isTurnOnMobileDataDialogEnabled() {
        Validator.sdkInitialized();
        return enableTurnOnMobileDataDialog;
    }

    public static ArrayList<Locale> getLocales() {
        Validator.sdkInitialized();
        return sLocales;
    }

    public static String getRedirectUri() {
        Validator.sdkInitialized();
        return redirectUri;
    }

    public static ArrayList<String> getUiLocales() {
        ArrayList<String> locales = new ArrayList<String>();
        if (ConnectSdk.getLocales() != null && !ConnectSdk.getLocales().isEmpty()) {
            for (Locale locale : ConnectSdk.getLocales()) {
                locales.add(locale.toString());
                locales.add(locale.getLanguage());
            }
        }
        locales.add(Locale.getDefault().toString());
        locales.add(Locale.getDefault().getLanguage());
        return locales;
    }

    public static String getExpectedIssuer() {
        Validator.sdkInitialized();
        if (ConnectSdk.getWellKnownConfig() != null) {
            return ConnectSdk.getWellKnownConfig().getIssuer();
        }
        return ConnectUrlHelper.getConnectApiUrl(idProvider, useStaging) + "oauth";
    }

    public static List<String> getExpectedAudiences() {
        Validator.sdkInitialized();
        return Collections.singletonList(clientId);
    }

    public static synchronized boolean isConfidentialClient() {
        Validator.sdkInitialized();
        return confidentialClient;
    }

    public static synchronized boolean isInitialized() {
        return isInitialized;
    }

    public static void logout() {
        Validator.sdkInitialized();
        connectIdService.logOut(ConnectSdk.getContext());
    }

    @Deprecated
    public static synchronized void sdkInitialize(Context applicationContext, boolean useStagingEnvironment) {
        ConnectSdk.sdkInitialize(applicationContext, IdProvider.CONNECT_ID, useStagingEnvironment);
    }

    public static synchronized void sdkInitialize(Context applicationContext) {
        ConnectSdk.sdkInitialize(applicationContext, IdProvider.CONNECT_ID, true);
    }

    public static synchronized void sdkInitialize(Context applicationContext, IdProvider provider, boolean useStagingEnvironment) {
        boolean noStoredWellKnownConfig;
        if (ConnectSdk.isInitialized()) {
            return;
        }
        context = applicationContext;
        Validator.notNull(context, "context");
        useStaging = useStagingEnvironment;
        idProvider = provider;
        ConnectSdk.loadConnectConfig(context);
        connectStore = new ConnectStore(context);
        lastSeenWellKnownConfigStore = new WellKnownConfigStore(context);
        wellKnownConfig = lastSeenWellKnownConfigStore.get();
        String apiUrl = ConnectUrlHelper.getConnectApiUrl(provider, useStaging).toString();
        connectIdService = new ConnectIdService(connectStore, RestHelper.getConnectApi(apiUrl), clientId, redirectUri);
        ConnectSdk.setRandomLogSessionId();
        boolean noSignedInUser = connectIdService.getAccessToken() == null;
        boolean bl = noStoredWellKnownConfig = wellKnownConfig == null;
        if (noSignedInUser || noStoredWellKnownConfig) {
            ConnectSdk.updateWellKnownConfig(apiUrl);
        }
        HeLogic.initializeNetworks(context, idProvider, useStaging);
        ConnectSdk.initializeAdvertisingId(context);
        isInitialized = true;
        tsSdkInitialization = System.currentTimeMillis();
    }

    private static void updateWellKnownConfig(String apiUrl) {
        RestHelper.getWellKnownApi(apiUrl).getWellKnownConfig().enqueue((Callback)new Callback<WellKnownAPI.WellKnownConfig>(){

            public void onResponse(Call<WellKnownAPI.WellKnownConfig> call, Response<WellKnownAPI.WellKnownConfig> response) {
                if (response.isSuccessful()) {
                    WellKnownAPI.WellKnownConfig config = (WellKnownAPI.WellKnownConfig)response.body();
                    wellKnownConfig = config;
                    lastSeenWellKnownConfigStore.set(config);
                } else {
                    wellKnownConfig = null;
                }
            }

            public void onFailure(Call<WellKnownAPI.WellKnownConfig> call, Throwable error) {
                wellKnownConfig = null;
            }
        });
    }

    private static String getMccMnc() {
        TelephonyManager tel = (TelephonyManager)ConnectSdk.getContext().getSystemService("phone");
        return tel.getNetworkOperator();
    }

    public static void setLocales(Locale ... locales) {
        sLocales = new ArrayList<Locale>(Arrays.asList(locales));
    }

    public static void setLocales(ArrayList<Locale> locales) {
        sLocales = locales;
    }

    public static void updateTokens(AccessTokenCallback callback) {
        Validator.sdkInitialized();
        connectIdService.updateTokens(callback);
    }

    private static void loadConnectConfig(Context context) {
        Object enableTurnOnMobileDataDialogObject;
        Object redirectUriObject;
        ApplicationInfo ai = ConnectSdk.getApplicationInfo(context);
        if (ai == null || ai.metaData == null) {
            throw new ConnectException("No application metadata was found.");
        }
        confidentialClient = ConnectSdk.fetchBooleanProperty(ai, CONFIDENTIAL_CLIENT_PROPERTY);
        Object clientIdObject = ai.metaData.get(CLIENT_ID_PROPERTY);
        if (clientIdObject instanceof String) {
            clientId = (String)clientIdObject;
        }
        if ((redirectUriObject = ai.metaData.get(REDIRECT_URI_PROPERTY)) instanceof String) {
            redirectUri = (String)redirectUriObject;
        }
        if ((enableTurnOnMobileDataDialogObject = ai.metaData.get(ENABLE_TURN_ON_MOBILE_DATA_DIALOG_PROPERTY)) instanceof Boolean) {
            enableTurnOnMobileDataDialog = (Boolean)enableTurnOnMobileDataDialogObject;
        }
    }

    private static ApplicationInfo getApplicationInfo(Context context) {
        try {
            return context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    private static boolean fetchBooleanProperty(ApplicationInfo appInfo, String propertyName) {
        if (appInfo == null) {
            return false;
        }
        if (appInfo.metaData == null) {
            return false;
        }
        Object booleanPropertyObject = appInfo.metaData.get(propertyName);
        if (!(booleanPropertyObject instanceof Boolean)) {
            return false;
        }
        return (Boolean)booleanPropertyObject;
    }

    public static WellKnownAPI.WellKnownConfig getWellKnownConfig() {
        Validator.sdkInitialized();
        return wellKnownConfig;
    }

    @Deprecated
    public static String getSubjectId() {
        Validator.sdkInitialized();
        IdToken idToken = connectIdService.getIdToken();
        return idToken != null ? idToken.getSubject() : null;
    }

    public static IdToken getIdToken() {
        Validator.sdkInitialized();
        return connectIdService.getIdToken();
    }

    public static void getUserInfo(Callback<UserInfo> userInfoCallback) {
        Validator.sdkInitialized();
        connectIdService.getUserInfo(userInfoCallback);
    }

    public static boolean hasValidRedirectUrlCall(Intent intent) {
        Uri data = intent.getData();
        if (data == null) {
            return false;
        }
        boolean startsWithCorrect = data.toString().startsWith(ConnectSdk.getRedirectUri());
        if (!startsWithCorrect) {
            return false;
        }
        String state = data.getQueryParameter("state");
        String originalState = connectStore.getSessionStateParam();
        if (originalState != null && !originalState.equals(state)) {
            return false;
        }
        String code = data.getQueryParameter("code");
        return code != null && !code.isEmpty();
    }

    public static boolean hasErrorRedirectUrlCall(Intent intent) {
        if (intent == null) {
            return false;
        }
        Uri uri = intent.getData();
        if (uri == null) {
            return false;
        }
        boolean startsWithCorrect = uri.toString().startsWith(ConnectSdk.getRedirectUri());
        if (!startsWithCorrect) {
            return false;
        }
        return uri.getQueryParameter("error") != null;
    }

    public static void openSelfServicePage(Context context) {
        if (!ConnectSdk.isInitialized() || idProvider == IdProvider.CONNECT_ID) {
            return;
        }
        Uri selfServiceUri = Uri.parse((String)ConnectUrlHelper.getSelfServiceUrl(idProvider, useStaging).newBuilder().addPathSegment("overview").build().uri().toString());
        try {
            CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().build();
            Intent intent = customTabsIntent.intent;
            if (Build.VERSION.SDK_INT >= 22) {
                intent.putExtra("android.intent.extra.REFERRER", (Parcelable)Uri.parse((String)("2//" + context.getPackageName())));
            }
            customTabsIntent.launchUrl(context, selfServiceUri);
        }
        catch (ActivityNotFoundException e) {
            ConnectSdk.sendAnalyticsData(e);
        }
        catch (Exception e) {
            ConnectSdk.sendAnalyticsData(e);
        }
    }

    public static void handleRedirectUriCallIfPresent(Intent intent, ConnectCallback callback) {
        if (!ConnectSdk.hasValidRedirectUrlCall(intent)) {
            return;
        }
        ConnectSdk.safeUnregisterAndRemoveBroadcastReceiver();
        String code = ConnectSdk.getCodeFromIntent(intent);
        ConnectSdk.getAccessTokenFromCode(code, callback);
    }

    private static void safeUnregisterAndRemoveBroadcastReceiver() {
        try {
            ConnectSdk.getContext().unregisterReceiver((BroadcastReceiver)smsBroadcastReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            smsBroadcastReceiver = null;
        }
    }

    public static String getCodeFromIntent(@NonNull Intent intent) {
        Uri data = intent.getData();
        return data.getQueryParameter("code");
    }

    private static void initializeAdvertisingId(final Context context) {
        GoogleApiAvailability googleAPI = GoogleApiAvailability.getInstance();
        if (googleAPI.isGooglePlayServicesAvailable(context) == 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AdvertisingIdClient.Info adInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
                        advertisingId = adInfo.getId();
                    }
                    catch (Exception e) {
                        Log.w((String)"ConnectSDK", (String)"Failed to read advertising id", (Throwable)e);
                    }
                }
            }).start();
        }
    }

    @Deprecated
    @TargetApi(value=21)
    public static Network getCellularNetwork() {
        return HeLogic.getCellularNetwork();
    }

    @TargetApi(value=21)
    public static Network getDefaultNetwork() {
        return HeLogic.getDefaultNetwork();
    }

    private static String getAdvertisingId() {
        return advertisingId;
    }

    public static String getLogSessionId() {
        return logSessionId;
    }

    private static String getApplicationName() {
        try {
            return ConnectSdk.getContext().getApplicationInfo().loadLabel(ConnectSdk.getContext().getPackageManager()).toString();
        }
        catch (Exception e) {
            Log.e((String)"ConnectSDK", (String)"Failed to read application name", (Throwable)e);
            return "";
        }
    }

    private static String getApplicationVersion() {
        try {
            return ConnectSdk.getContext().getPackageManager().getPackageInfo((String)ConnectSdk.getContext().getPackageName(), (int)0).versionName;
        }
        catch (Exception e) {
            Log.e((String)"ConnectSDK", (String)"Failed to read application version", (Throwable)e);
            return "";
        }
    }

    public static IdProvider getIdProvider() {
        Validator.sdkInitialized();
        return idProvider;
    }

    public static void setIdProvider(IdProvider newIdProvider) {
        Validator.sdkInitialized();
        idProvider = newIdProvider;
    }

    public static boolean useStaging() {
        Validator.sdkInitialized();
        return useStaging;
    }

    public static ConnectStore getConnectStore() {
        Validator.sdkInitialized();
        return connectStore;
    }

    static {
        isInitialized = false;
    }
}

