/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.telenor.connect.AnalyticsAPI;
import com.telenor.connect.WellKnownAPI;
import com.telenor.connect.id.ConnectAPI;
import com.telenor.connect.id.IdToken;
import com.telenor.connect.id.IdTokenDeserializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class RestHelper {
    private static Map<String, ConnectAPI> connectApiMap = new HashMap<String, ConnectAPI>();
    private static Map<String, WellKnownAPI> wellKnownApiMap = new HashMap<String, WellKnownAPI>();
    private static Map<String, AnalyticsAPI> analyticsApiMap = new HashMap<String, AnalyticsAPI>();

    public static ConnectAPI getConnectApi(String endpoint) {
        return RestHelper.getApi(connectApiMap, endpoint, ConnectAPI.class);
    }

    public static WellKnownAPI getWellKnownApi(String endpoint) {
        return RestHelper.getApi(wellKnownApiMap, endpoint, WellKnownAPI.class);
    }

    public static AnalyticsAPI getAnalyticsApi(String endpoint) {
        return RestHelper.getApi(analyticsApiMap, endpoint, AnalyticsAPI.class);
    }

    private static synchronized <T> T getApi(Map<String, T> map, String endpoint, Class<T> type) {
        Object api = map.get(endpoint);
        if (api == null) {
            api = RestHelper.buildApi(endpoint).create(type);
            map.put(endpoint, api);
        }
        return api;
    }

    private static Retrofit buildApi(String endpoint) {
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
        logging.setLevel(HttpLoggingInterceptor.Level.NONE);
        Interceptor headers = new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                return chain.proceed(chain.request().newBuilder().header("Accept", "application/json").build());
            }
        };
        OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).addInterceptor((Interceptor)logging).addInterceptor(headers).build();
        Gson gson = new GsonBuilder().registerTypeAdapter(IdToken.class, (Object)new IdTokenDeserializer()).create();
        return new Retrofit.Builder().callFactory((Call.Factory)httpClient).baseUrl(endpoint).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
    }
}

