/*
 * Decompiled with CFR 0.152.
 */
package com.telenor.connect.ui;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.os.Build;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.telenor.connect.ConnectSdk;
import com.telenor.connect.R;
import com.telenor.connect.ui.ConnectTextView;

public class ConnectAboutTextView
extends ConnectTextView {
    private PopupWindow popupWindow;

    public ConnectAboutTextView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initControls();
        this.initVisuals(context);
    }

    private void initControls() {
        this.setAllCaps(false);
        this.setFocusable(true);
        this.setClickable(true);
    }

    private void initVisuals(final Context context) {
        final AssetManager am = context.getApplicationContext().getAssets();
        this.setTypeface(Typeface.createFromAsset((AssetManager)am, (String)"fonts/telenorlightwebfont.ttf"));
        CharSequence linkText = this.getResources().getText(R.string.com_telenor_about_link);
        SpannableString spannableLinkText = new SpannableString(linkText);
        ClickableSpan clickableSpannableLinkText = new ClickableSpan(){

            public void onClick(@NonNull View textView) {
                ConnectAboutTextView.this.openPopup(context);
            }

            public void updateDrawState(@NonNull TextPaint ds) {
                super.updateDrawState(ds);
                ds.setTypeface(Typeface.createFromAsset((AssetManager)am, (String)"fonts/telenorboldwebfont.ttf"));
                ds.setColor(ConnectAboutTextView.this.getCurrentTextColor());
                ds.setUnderlineText(false);
            }
        };
        SpannableStringBuilder longDescription = new SpannableStringBuilder();
        longDescription.append((CharSequence)this.getResources().getString(R.string.com_telenor_about_description, new Object[]{ConnectSdk.getIdProvider().getName()}));
        spannableLinkText.setSpan((Object)clickableSpannableLinkText, 0, linkText.length(), 33);
        longDescription.append((CharSequence)spannableLinkText);
        this.setText((CharSequence)longDescription, TextView.BufferType.SPANNABLE);
        this.setMovementMethod(LinkMovementMethod.getInstance());
        this.setHighlightColor(0);
    }

    private void openPopup(Context context) {
        View view = this.getActivity().getLayoutInflater().inflate(R.layout.com_telenor_connect_about, null, false);
        if (Build.VERSION.SDK_INT < 22) {
            view.setPadding(0, this.spToPx(context, 20.0f), 0, 0);
        }
        AssetManager am = context.getApplicationContext().getAssets();
        TextView title = (TextView)view.findViewById(R.id.connect_about_title);
        TextView subTitle = (TextView)view.findViewById(R.id.connect_about_subtitle);
        TextView description = (TextView)view.findViewById(R.id.connect_about_description);
        ImageView closeIcon = (ImageView)view.findViewById(R.id.connect_about_close);
        title.setTypeface(Typeface.createFromAsset((AssetManager)am, (String)"fonts/telenorboldwebfont.ttf"));
        title.setText((CharSequence)this.getResources().getString(R.string.com_telenor_about_screen_title, new Object[]{ConnectSdk.getIdProvider().getName()}));
        subTitle.setTypeface(Typeface.createFromAsset((AssetManager)am, (String)"fonts/telenorregularwebfont.ttf"));
        subTitle.setText((CharSequence)this.getResources().getString(R.string.com_telenor_about_screen_subtitle, new Object[]{ConnectSdk.getIdProvider().getName()}));
        description.setTypeface(Typeface.createFromAsset((AssetManager)am, (String)"fonts/telenorlightwebfont.ttf"));
        description.setText((CharSequence)this.getResources().getString(R.string.com_telenor_about_screen_description, new Object[]{ConnectSdk.getIdProvider().getName()}));
        if (this.popupWindow != null) {
            this.popupWindow.dismiss();
        }
        this.popupWindow = new PopupWindow(view, -1, -1);
        this.popupWindow.setAnimationStyle(R.style.com_telenor_popup_animation);
        this.popupWindow.showAtLocation(view, 80, 0, 0);
        closeIcon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConnectAboutTextView.this.popupWindow.dismiss();
            }
        });
    }

    private int spToPx(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }
}

